/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.Calendar;
import java.util.Date;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.UIPageNodeSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.UIWizard;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/portal/webui/page/UIWizardPageSetInfo.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SwitchPublicationDateActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIWizardPageSetInfo
extends UIForm {
    public static final String PAGE_NAME = "pageName";
    public static final String PAGE_DISPLAY_NAME = "pageDisplayName";
    public static final String VISIBLE = "visible";
    public static final String SHOW_PUBLICATION_DATE = "showPublicationDate";
    public static final String START_PUBLICATION_DATE = "startPublicationDate";
    public static final String END_PUBLICATION_DATE = "endPublicationDate";
    private boolean isEditMode = false;
    private boolean firstTime = true;

    public UIWizardPageSetInfo() throws Exception {
        this.addChild(UIPageNodeSelector.class, null, null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PAGE_NAME, "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(IdentifierValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PAGE_DISPLAY_NAME, "label", null).setMaxLength(255).addValidator(StringLengthValidator.class, new Object[]{3, 120}));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(VISIBLE, VISIBLE, (Object)false).setChecked(true));
        UIFormCheckBoxInput uiDateInputCheck = new UIFormCheckBoxInput(SHOW_PUBLICATION_DATE, SHOW_PUBLICATION_DATE, (Object)false);
        uiDateInputCheck.setOnChange("SwitchPublicationDate");
        this.addUIFormInput((UIFormInput)uiDateInputCheck);
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0]).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0]).addValidator(MandatoryValidator.class, new Object[0]));
    }

    public void setEditMode() throws Exception {
        this.isEditMode = true;
        UIFormStringInput uiNameInput = (UIFormStringInput)this.getChildById(PAGE_NAME);
        uiNameInput.setEditable(false);
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void invokeSetBindingBean(Object bean) throws Exception {
        super.invokeSetBindingBean(bean);
        PageNode node = (PageNode)bean;
        node.setVisible(Boolean.valueOf(this.getUIFormCheckBoxInput(VISIBLE).isChecked()));
        Calendar cal = this.getUIFormDateTimeInput(START_PUBLICATION_DATE).getCalendar();
        Date date = cal != null ? cal.getTime() : null;
        node.setStartPublicationDate(date);
        cal = this.getUIFormDateTimeInput(END_PUBLICATION_DATE).getCalendar();
        date = cal != null ? cal.getTime() : null;
        node.setEndPublicationDate(date);
    }

    public PageNode getPageNode() throws Exception {
        if (this.isEditMode) {
            PageNode pageNode = this.getSelectedPageNode();
            PageNode clonedNode = pageNode != null ? pageNode.clone() : null;
            this.invokeSetBindingBean(clonedNode);
            if (clonedNode.getLabel() == null || clonedNode.getLabel().trim().length() == 0) {
                clonedNode.setLabel(clonedNode.getName());
            }
            return clonedNode;
        }
        PageNode pageNode = new PageNode();
        this.invokeSetBindingBean(pageNode);
        if (pageNode.getLabel() == null || pageNode.getLabel().trim().length() == 0) {
            pageNode.setLabel(pageNode.getName());
        }
        UIPageNodeSelector uiNodeSelector = (UIPageNodeSelector)this.getChild(UIPageNodeSelector.class);
        PageNode selectedNode = uiNodeSelector.getSelectedPageNode();
        PageNavigation nav = uiNodeSelector.getSelectedNavigation();
        if (nav.getOwnerType().equals("user")) {
            pageNode.setUri(pageNode.getName());
        } else if (selectedNode != null) {
            pageNode.setUri(selectedNode.getUri() + "/" + pageNode.getName());
        } else {
            pageNode.setUri(pageNode.getName());
        }
        return pageNode;
    }

    public void setShowPublicationDate(boolean show) {
        this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE).setChecked(show);
        this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setRendered(show);
        this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setRendered(show);
    }

    public void setPageNode(PageNode pageNode) throws Exception {
        if (pageNode.getName() != null) {
            this.getUIStringInput(PAGE_NAME).setValue((Object)pageNode.getName());
        }
        if (pageNode.getLabel() != null) {
            this.getUIStringInput(PAGE_DISPLAY_NAME).setValue((Object)pageNode.getLabel());
        }
        this.getUIFormCheckBoxInput(VISIBLE).setChecked(pageNode.isVisible());
        this.setShowPublicationDate(pageNode.isShowPublicationDate());
        Calendar cal = Calendar.getInstance();
        if (pageNode.getStartPublicationDate() != null) {
            cal.setTime(pageNode.getStartPublicationDate());
            this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setCalendar(cal);
        } else {
            this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setValue(null);
        }
        if (pageNode.getEndPublicationDate() != null) {
            cal.setTime(pageNode.getEndPublicationDate());
            this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setCalendar(cal);
        } else {
            this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setValue(null);
        }
    }

    public PageNode getSelectedPageNode() {
        UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)this.getChild(UIPageNodeSelector.class);
        PageNavigation nav = uiPageNodeSelector.getSelectedNavigation();
        if (nav.getOwnerType().equals("user")) {
            return null;
        }
        return uiPageNodeSelector.getSelectedPageNode();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.isEditMode && ((UIPageNodeSelector)this.getChild(UIPageNodeSelector.class)).getSelectedPageNode() == null) {
            this.reset();
        }
        super.processRender(context);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        String action = context.getRequestParameter("formOp");
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwitchPublicationDateActionListener
    extends EventListener<UIWizardPageSetInfo> {
        public void execute(Event<UIWizardPageSetInfo> event) throws Exception {
            UIWizardPageSetInfo uiForm = (UIWizardPageSetInfo)((Object)event.getSource());
            boolean isCheck = uiForm.getUIFormCheckBoxInput(UIWizardPageSetInfo.SHOW_PUBLICATION_DATE).isChecked();
            uiForm.getUIFormDateTimeInput(UIWizardPageSetInfo.START_PUBLICATION_DATE).setRendered(isCheck);
            uiForm.getUIFormDateTimeInput(UIWizardPageSetInfo.END_PUBLICATION_DATE).setRendered(isCheck);
            UIWizard uiWizard = (UIWizard)uiForm.getAncestorOfType(UIWizard.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizard);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIWizardPageSetInfo> {
        public void execute(Event<UIWizardPageSetInfo> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIWizardPageSetInfo uiForm = (UIWizardPageSetInfo)((Object)event.getSource());
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UIWizardPageSetInfo)((Object)event.getSource())).getChild(UIPageNodeSelector.class);
            UITree tree = (UITree)uiPageNodeSelector.getChild(UITree.class);
            if (tree.getParentSelected() == null && (uri == null || uri.length() < 1)) {
                uiPageNodeSelector.selectNavigation(uiPageNodeSelector.getSelectedNavigation());
            } else {
                uiPageNodeSelector.selectPageNodeByUri(uri);
            }
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageNodeSelector.getAncestorOfType(UIPortalApplication.class);
            UIWizard uiWizard = (UIWizard)uiPortalApp.findFirstComponentOfType(UIWizard.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizard);
            if (!((UIWizardPageSetInfo)((Object)event.getSource())).isEditMode()) {
                return;
            }
            PageNode pageNode = uiPageNodeSelector.getSelectedPageNode();
            if (pageNode == null && uiForm.isFirstTime()) {
                uiForm.setShowPublicationDate(false);
                uiForm.setFirstTime(false);
                UIPortal uiPortal = Util.getUIPortal();
                uiPageNodeSelector.selectNavigation(uiPortal.getSelectedNavigation());
                if (uiPortal.getSelectedNode() != null) {
                    uiPageNodeSelector.selectPageNodeByUri(uiPortal.getSelectedNode().getUri());
                }
                pageNode = uiPageNodeSelector.getSelectedPageNode();
            }
            if (pageNode == null) {
                uiForm.setShowPublicationDate(false);
                return;
            }
            UserPortalConfigService configService = (UserPortalConfigService)uiWizard.getApplicationComponent(UserPortalConfigService.class);
            String accessUser = event.getRequestContext().getRemoteUser();
            Page page = null;
            if (pageNode.getPageReference() != null) {
                page = configService.getPage(pageNode.getPageReference(), accessUser);
            }
            if (page == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIWizardPageSetInfo.msg.null", null));
                uiForm.reset();
                uiForm.setShowPublicationDate(false);
                return;
            }
            uiForm.setPageNode(pageNode);
        }
    }
}

