/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.auth;

import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.jacc.PolicyContext;
import org.jboss.security.ServerAuthenticationManager;
import org.jboss.security.plugins.auth.JaasSecurityManagerBase;

public class JASPIServerAuthenticationManager
extends JaasSecurityManagerBase
implements ServerAuthenticationManager {
    public JASPIServerAuthenticationManager() {
    }

    public JASPIServerAuthenticationManager(String securityDomain, CallbackHandler handler) {
        super(securityDomain, handler);
    }

    public boolean isValid(MessageInfo requestMessage, Subject clientSubject, String layer, CallbackHandler handler) {
        AuthStatus status = AuthStatus.FAILURE;
        try {
            String contextID = PolicyContext.getContextID();
            AuthConfigFactory factory = AuthConfigFactory.getFactory();
            AuthConfigProvider provider = factory.getConfigProvider(layer, contextID, null);
            if (provider == null) {
                throw new IllegalStateException("Provider is null for " + layer + " for " + contextID);
            }
            ServerAuthConfig serverConfig = provider.getServerAuthConfig(layer, contextID, handler);
            ServerAuthContext sctx = serverConfig.getAuthContext(contextID, new Subject(), new HashMap());
            if (clientSubject == null) {
                clientSubject = new Subject();
            }
            Subject serviceSubject = new Subject();
            status = sctx.validateRequest(requestMessage, clientSubject, serviceSubject);
        }
        catch (AuthException ae) {
            this.log.trace((Object)"AuthException:", (Throwable)ae);
        }
        return AuthStatus.SUCCESS == status;
    }
}

