/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.Serializable;
import java.net.MalformedURLException;
import org.jboss.logging.Logger;

public class JMXServiceURL
implements Serializable {
    private static final long serialVersionUID = 8173364409860779292L;
    public static final String REQUIRED_URL_PREFIX = "service:jmx:";
    private static final int DEFAULT_PORT = 0;
    private String protocol = null;
    private String host = null;
    private int port = 0;
    private String urlPath = "";
    private transient String stringServiceURL = null;
    protected transient Logger log = Logger.getLogger(this.getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JMXServiceURL(String serviceURL) throws MalformedURLException {
        if (serviceURL == null) throw new NullPointerException("Can not create JMXServiceURL due to constructor parameter being null.");
        if (!serviceURL.startsWith(REQUIRED_URL_PREFIX)) throw new MalformedURLException("Can not create JMXServiceURL due to provided service url not starting with service:jmx:.  URL String provided was: " + serviceURL);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Start parsing of jmx service url: " + serviceURL));
        }
        this.parseCoreURL(serviceURL.substring(REQUIRED_URL_PREFIX.length()));
    }

    public JMXServiceURL(String protocol, String host, int port) throws MalformedURLException {
        this(protocol, host, port, null);
    }

    public JMXServiceURL(String protocol, String host, int port, String urlPath) throws MalformedURLException {
        this.setProtocol(protocol);
        this.setHost(host);
        this.setPort(port);
        this.setPath(urlPath);
    }

    private void parseCoreURL(String serviceURL) throws MalformedURLException {
        String protocolSeperator = "://";
        int index = serviceURL.indexOf("://");
        if (index == -1) {
            this.log.error((Object)("Error parsing core jmx service url.  Could not find protocol within string " + serviceURL));
            throw new MalformedURLException("Error in parsing JMX service URL.  Does not properly define protocol.");
        }
        String invalidatedProtocol = serviceURL.substring(0, index);
        this.setProtocol(this.validateProtocol(invalidatedProtocol));
        String hostPlus = serviceURL.substring(index + "://".length());
        String path = this.parseHostAndPort(hostPlus);
        if (path != null && path.length() > 0) {
            this.setPath(this.validatePath(path));
        }
        this.log.debug((Object)("Have parsed jmx service url into following values - protocol: " + this.getProtocol() + ", host: " + this.getHost() + ", port: " + this.getPort() + ", path: " + this.getURLPath()));
    }

    private String validatePath(String path) throws MalformedURLException {
        if (!path.startsWith("/") && !path.startsWith(";")) {
            throw new MalformedURLException("Error parsing JMX service URL.  The path did not begin with either a '/' or ';' character.");
        }
        return path;
    }

    private void setPath(String path) {
        this.urlPath = path == null ? "" : path;
    }

    private String parseHostAndPort(String hostPlus) throws MalformedURLException {
        String pathString = null;
        int index = -1;
        index = hostPlus.indexOf(59);
        int n = index = index == -1 ? hostPlus.indexOf(47) : index;
        if (index != -1) {
            this.setHost(null);
            pathString = hostPlus.substring(index);
        }
        String string = hostPlus = index == -1 ? hostPlus : hostPlus.substring(0, index);
        if (hostPlus.length() != 0) {
            int endOfHostIndex = -1;
            if (hostPlus.charAt(0) == '[') {
                endOfHostIndex = hostPlus.lastIndexOf(93);
                if (endOfHostIndex == -1) {
                    this.log.error((Object)("Could not process service url section " + hostPlus + " due to the host section " + "starting with [ but no ending ] before the path seperator."));
                    throw new MalformedURLException("Error parsing JMX service URL.  Host started with [, but did not have an end ].");
                }
                String ipv6Host = hostPlus.substring(1, endOfHostIndex);
                this.setHost(ipv6Host);
                ++endOfHostIndex;
            } else {
                endOfHostIndex = hostPlus.indexOf(58);
                if (endOfHostIndex != -1) {
                    if (endOfHostIndex == 0) {
                        throw new MalformedURLException("Error parsing JMX service URL.  Port specified, but not host.");
                    }
                    this.setHost(hostPlus.substring(0, endOfHostIndex));
                } else {
                    this.setHost(hostPlus);
                }
            }
            if (endOfHostIndex != -1 && hostPlus.length() > endOfHostIndex) {
                String portString = hostPlus.substring(endOfHostIndex);
                if (portString.charAt(0) != ':') {
                    this.log.error((Object)("Error parsing host and port of jmx service url.  Host and port must be seperated by ':'.  Offending serviceURL section is " + hostPlus));
                    throw new MalformedURLException("Error in parsing JMX service URL.  Host and port must be seperated by ':'.");
                }
                if (this.getHost() == null || this.getHost().length() == 0) {
                    throw new MalformedURLException("Error parsing JMX service URL.  Can not have port specified without having a host specified as well.");
                }
                String invalidatedPort = portString.substring(1);
                this.setPort(this.validatePort(invalidatedPort));
            }
        }
        return pathString;
    }

    private void setHost(String serviceHost) {
        this.host = serviceHost == null ? null : (serviceHost.charAt(0) == '[' && serviceHost.charAt(serviceHost.length() - 1) == ']' ? serviceHost.substring(1, serviceHost.length() - 1) : serviceHost);
    }

    private void setPort(int port) {
        this.port = port;
    }

    private int validatePort(String invalidatedPort) throws MalformedURLException {
        int validatedPort = 0;
        try {
            validatedPort = Integer.parseInt(invalidatedPort);
            if (validatedPort == 0) {
                validatedPort = 0;
            }
        }
        catch (NumberFormatException e) {
            throw new MalformedURLException("Error converting JMX Service url port (" + invalidatedPort + ") to a numeric value.");
        }
        return validatedPort;
    }

    private void setProtocol(String protocol) throws MalformedURLException {
        this.protocol = this.validateProtocol(protocol);
    }

    private String validateProtocol(String protocol) throws MalformedURLException {
        if (protocol == null || protocol.length() == 0) {
            return "jmxmp";
        }
        for (int x = 0; x < protocol.length(); ++x) {
            char c = protocol.charAt(x);
            if (c == '+' || c == '-' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            throw new MalformedURLException("Error in parsing JMX service ULR protocol because contains no valid character 0x" + Integer.toHexString(c));
        }
        return protocol.toLowerCase();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    public String toString() {
        if (this.stringServiceURL == null) {
            int port;
            StringBuffer buffer = new StringBuffer(REQUIRED_URL_PREFIX);
            buffer.append(this.getProtocol());
            buffer.append("://");
            String host = this.getHost();
            if (host != null) {
                if (host.indexOf(58) != -1) {
                    buffer.append("[");
                    buffer.append(host);
                    buffer.append("]");
                } else {
                    buffer.append(host);
                }
            }
            if ((port = this.getPort()) > 0) {
                buffer.append(":");
                buffer.append(port);
            }
            buffer.append(this.getURLPath());
            this.stringServiceURL = buffer.toString();
        }
        return this.stringServiceURL;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JMXServiceURL) {
            JMXServiceURL jsu = (JMXServiceURL)obj;
            if (this.getProtocol().equalsIgnoreCase(jsu.getProtocol()) && this.getPort() == jsu.getPort()) {
                String host = this.getHost();
                if (host == null) {
                    if (jsu.getHost() != null) {
                        return false;
                    }
                    String urlPath = this.getURLPath();
                    if (urlPath == null && jsu.getURLPath() != null) {
                        return false;
                    }
                    return urlPath.equals(jsu.getURLPath());
                }
                if (host.equals(jsu.getHost())) {
                    String urlPath = this.getURLPath();
                    if (urlPath == null && jsu.getURLPath() != null) {
                        return false;
                    }
                    return urlPath.equals(jsu.getURLPath());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

