/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.content;

import java.io.InputStream;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.content.ContentServiceResponse;
import org.rhq.core.domain.content.ContentRequestStatus;
import org.rhq.core.domain.content.transfer.RetrievePackageBitsRequest;
import org.rhq.core.pc.content.ContentManager;

public class RetrieveContentBitsRunner
implements Runnable {
    private ContentManager contentManager;
    private RetrievePackageBitsRequest request;

    public RetrieveContentBitsRunner(ContentManager contentManager, RetrievePackageBitsRequest request) {
        this.contentManager = contentManager;
        this.request = request;
    }

    public void run() {
        ContentServiceResponse response = new ContentServiceResponse(this.request.getRequestId());
        InputStream inputStream = null;
        try {
            inputStream = this.contentManager.performGetPackageBits(this.request.getResourceId(), this.request.getPackageDetails());
            if (inputStream == null) {
                response.setErrorMessage("Null input stream received from plugin");
                response.setStatus(ContentRequestStatus.FAILURE);
            } else {
                response.setStatus(ContentRequestStatus.SUCCESS);
            }
        }
        catch (Throwable throwable) {
            response.setErrorMessageFromThrowable(throwable);
            response.setStatus(ContentRequestStatus.FAILURE);
        }
        ContentServerService serverService = this.contentManager.getContentServerService();
        if (serverService != null) {
            serverService.completeRetrievePackageBitsRequest(response, inputStream);
        }
    }
}

