/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.TcpConnectionMBean;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioTcpChannel
implements TcpChannel,
Closeable {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.channel");
    private final SocketChannel socketChannel;
    private final Socket socket;
    private final IoHandler<? super TcpChannel> handler;
    private final NioHandle readHandle;
    private final NioHandle writeHandle;
    private final NioXnio nioXnio;
    private final AtomicBoolean closeCalled = new AtomicBoolean(false);
    private final AtomicLong bytesRead = new AtomicLong();
    private final AtomicLong bytesWritten = new AtomicLong();
    private final AtomicLong msgsRead = new AtomicLong();
    private final AtomicLong msgsWritten = new AtomicLong();
    private final Closeable mbeanHandle;
    private static final Set<ChannelOption<?>> OPTIONS = Collections.singleton(CommonOptions.CLOSE_ABORT);

    public NioTcpChannel(NioXnio nioXnio, SocketChannel socketChannel, IoHandler<? super TcpChannel> handler, Executor executor, boolean manage) throws IOException {
        this.handler = handler;
        this.socketChannel = socketChannel;
        this.nioXnio = nioXnio;
        this.socket = socketChannel.socket();
        if (executor != null) {
            this.readHandle = nioXnio.addReadHandler(socketChannel, new ReadHandler(), executor);
            this.writeHandle = nioXnio.addWriteHandler(socketChannel, new WriteHandler(), executor);
        } else {
            this.readHandle = nioXnio.addReadHandler(socketChannel, new ReadHandler());
            this.writeHandle = nioXnio.addWriteHandler(socketChannel, new WriteHandler());
        }
        try {
            this.mbeanHandle = manage ? nioXnio.registerMBean(new MBean()) : IoUtils.nullCloseable();
        }
        catch (NotCompliantMBeanException e) {
            throw new IOException("Failed to register channel mbean: " + e);
        }
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long written = this.socketChannel.write(srcs, offset, length);
        if (written > 0L) {
            this.bytesWritten.addAndGet(written);
            this.msgsWritten.incrementAndGet();
        }
        return written;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        long written = this.socketChannel.write(srcs);
        if (written > 0L) {
            this.bytesWritten.addAndGet(written);
            this.msgsWritten.incrementAndGet();
        }
        return written;
    }

    public int write(ByteBuffer src) throws IOException {
        int written = this.socketChannel.write(src);
        if (written > 0) {
            this.bytesWritten.addAndGet(written);
            this.msgsWritten.incrementAndGet();
        }
        return written;
    }

    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (!this.closeCalled.getAndSet(true)) {
            log.trace("Closing %s", (Object)this);
            HandlerUtils.handleClosed(this.handler, this);
            this.nioXnio.removeManaged(this);
            IoUtils.safeClose((Closeable)this.mbeanHandle);
            this.socketChannel.close();
        }
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long read = this.socketChannel.read(dsts, offset, length);
        if (read > 0L) {
            this.bytesRead.addAndGet(read);
            this.msgsRead.incrementAndGet();
        }
        return read;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long read = this.socketChannel.read(dsts);
        if (read > 0L) {
            this.bytesRead.addAndGet(read);
            this.msgsRead.incrementAndGet();
        }
        return read;
    }

    public int read(ByteBuffer dst) throws IOException {
        int read = this.socketChannel.read(dst);
        if (read > 0) {
            this.bytesRead.addAndGet(read);
            this.msgsRead.incrementAndGet();
        }
        return read;
    }

    public void suspendReads() {
        try {
            this.readHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void suspendWrites() {
        try {
            this.writeHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeReads() {
        try {
            this.readHandle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        try {
            this.writeHandle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void shutdownReads() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownWrites() throws IOException {
        this.socket.shutdownOutput();
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.socketChannel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.socketChannel, 1, time, timeUnit);
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.socketChannel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.socketChannel, 4, time, timeUnit);
    }

    public SocketAddress getPeerAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (option == null) {
            throw new NullPointerException("name is null");
        }
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (CommonOptions.CLOSE_ABORT.equals(option)) {
            return (T)Boolean.valueOf(this.socket.getSoLinger() != -1);
        }
        throw new UnsupportedOptionException("Option " + option + " not supported");
    }

    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == null) {
            throw new NullPointerException("name is null");
        }
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (CommonOptions.CLOSE_ABORT.equals(option)) {
            if (value == null) {
                throw new NullPointerException("value is null");
            }
            this.socket.setSoLinger((Boolean)value, 0);
        }
        return this;
    }

    public String toString() {
        return String.format("TCP socket channel (NIO) <%s> (local: %s, remote: %s)", Integer.toString(this.hashCode(), 16), this.getLocalAddress(), this.getPeerAddress());
    }

    public final class MBean
    extends StandardMBean
    implements TcpConnectionMBean {
        public MBean() throws NotCompliantMBeanException {
            super(TcpConnectionMBean.class);
        }

        public long getBytesRead() {
            return NioTcpChannel.this.bytesRead.get();
        }

        public long getBytesWritten() {
            return NioTcpChannel.this.bytesWritten.get();
        }

        public long getMessagesRead() {
            return NioTcpChannel.this.msgsRead.get();
        }

        public long getMessagesWritten() {
            return NioTcpChannel.this.msgsWritten.get();
        }

        public String toString() {
            return "ChannelMBean";
        }

        public SocketAddress getPeerAddress() {
            return NioTcpChannel.this.socket.getLocalSocketAddress();
        }

        public SocketAddress getBindAddress() {
            return NioTcpChannel.this.socket.getRemoteSocketAddress();
        }

        public void close() {
            IoUtils.safeClose((Closeable)NioTcpChannel.this);
        }
    }

    private final class WriteHandler
    implements Runnable {
        private WriteHandler() {
        }

        public void run() {
            HandlerUtils.handleWritable(NioTcpChannel.this.handler, NioTcpChannel.this);
        }
    }

    private final class ReadHandler
    implements Runnable {
        private ReadHandler() {
        }

        public void run() {
            HandlerUtils.handleReadable(NioTcpChannel.this.handler, NioTcpChannel.this);
        }
    }
}

