/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Session;
import org.exoplatform.services.ftp.command.FtpCommandImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdRetr
extends FtpCommandImpl {
    private static Log log = ExoLogger.getLogger("jcr.ftpservice.CmdRetr");

    public CmdRetr() {
        this.commandName = "RETR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] params) throws IOException {
        if (this.clientSession().getDataTransiver() == null) {
            this.reply("425 Unable to build data connection");
            return;
        }
        if (params.length < 2) {
            this.reply(String.format("500 %s: command requires a parameter", "RETR"));
            return;
        }
        String resName = params[1];
        boolean isResource = this.IsResource(resName);
        if (!isResource) {
            this.reply(String.format("550 %s: Permission denied", resName));
            return;
        }
        try {
            ArrayList<String> newPath = this.clientSession().getFullPath(resName);
            Session curSession = this.clientSession().getSession(newPath.get(0));
            String repoPath = this.clientSession().getRepoPath(newPath);
            Node parentNode = (Node)curSession.getItem(repoPath);
            Node dataNode = parentNode.getNode("jcr:content");
            Property dataProp = dataNode.getProperty("jcr:data");
            InputStream inStream = dataProp.getStream();
            if ("REST".equals(this.clientSession().getPrevCommand())) {
                String prevVal = this.clientSession().getPrevParams();
                int seekPos = new Integer(prevVal);
                if (seekPos > inStream.available()) {
                    this.reply("550 Restore value invalid");
                    return;
                }
                for (int i = 0; i < seekPos; ++i) {
                    inStream.read();
                }
            }
            while (!this.clientSession().getDataTransiver().isConnected()) {
                Thread.sleep(100L);
            }
            this.reply("125 Data connection already open; Transfer starting");
            int BUFFER_SIZE = 4096;
            try {
                int readed;
                byte[] buffer = new byte[BUFFER_SIZE];
                OutputStream outStream = this.clientSession().getDataTransiver().getOutputStream();
                while ((readed = inStream.read(buffer, 0, BUFFER_SIZE)) >= 0) {
                    outStream.write(buffer, 0, readed);
                }
            }
            catch (Exception exc) {
                this.reply("451 Transfer aborted");
                return;
            }
            finally {
                this.clientSession().closeDataTransiver();
            }
            this.reply("226 Transfer complete");
            return;
        }
        catch (Throwable exc) {
            log.info("Unhandled exception. " + exc.getMessage(), exc);
            this.clientSession().closeDataTransiver();
            this.reply(String.format("550 %s: Permission denied", resName));
            return;
        }
    }

    public boolean IsResource(String resName) {
        ArrayList<String> newPath = this.clientSession().getFullPath(resName);
        try {
            String repoPath = this.clientSession().getRepoPath(newPath);
            Session curSession = this.clientSession().getSession(newPath.get(0));
            Node parentNode = (Node)curSession.getItem(repoPath);
            if (parentNode.isNodeType("nt:file")) {
                return true;
            }
        }
        catch (PathNotFoundException exc) {
        }
        catch (NoSuchWorkspaceException wexc) {
        }
        catch (Throwable exc) {
            log.info("Unhandled exception. " + exc.getMessage(), exc);
        }
        return false;
    }
}

