/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webservice.cs.calendar;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.PathNotFoundException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webservice.cs.bean.CalendarData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/cs/calendar")
public class CalendarWebservice
implements ResourceContainer {
    public static final String BASE_RSS_URL = "/cs/calendar/feed".intern();
    public static final String BASE_EVENT_URL = "/cs/calendar/event".intern();
    public static final String BASE_URL_PUBLIC = "/cs/calendar/subscribe/".intern();
    public static final String BASE_URL_PRIVATE = "/cs/calendar/private/".intern();

    protected void start() {
        PortalContainer manager = PortalContainer.getInstance();
        OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        ((ComponentRequestLifecycle)oService).startRequest((ExoContainer)manager);
    }

    protected void stop() {
        PortalContainer manager = PortalContainer.getInstance();
        OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        ((ComponentRequestLifecycle)oService).endRequest((ExoContainer)manager);
    }

    @GET
    @Path(value="/checkPermission/{username}/{calendarId}/{type}/")
    public Response checkPermission(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        StringBuffer buffer = new StringBuffer();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar cal = null;
            buffer.append("{canEdit:0}");
            if (0 == Integer.parseInt(type)) {
                buffer = new StringBuffer("{canEdit:1}");
            } else if (2 == Integer.parseInt(type)) {
                this.start();
                OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                cal = calService.getGroupCalendar(calendarId);
                if (Utils.canEdit((OrganizationService)oService, (String[])cal.getEditPermission(), (String)username)) {
                    buffer = new StringBuffer("{canEdit:1}");
                }
                this.stop();
            } else if (1 == Integer.parseInt(type) && calService.getSharedCalendars(username, true) != null && Utils.canEdit(null, (String[])(cal = calService.getSharedCalendars(username, true).getCalendarById(calendarId)).getEditPermission(), (String)username)) {
                buffer = new StringBuffer("{canEdit:1}");
            }
        }
        catch (Exception e) {
            buffer = new StringBuffer("{ERROR:500 " + e + "}");
        }
        return Response.ok((Object)buffer.toString(), (String)"application/json").cacheControl(cacheControl).build();
    }

    @GET
    @Path(value="/event/{username}/{eventFeedName}/")
    public Response event(@PathParam(value="username") String username, @PathParam(value="eventFeedName") String eventFeedName) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            EventQuery eventQuery;
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            CalendarImportExport icalEx = calService.getCalendarImportExports(CalendarService.ICALENDAR);
            String eventId = eventFeedName.split("splitter")[0];
            String type = eventFeedName.split("splitter")[1].replace(Utils.ICS_EXT, "");
            CalendarEvent event = null;
            if (type.equals("0")) {
                event = calService.getEvent(username, eventId);
            } else if (type.equals("1")) {
                eventQuery = new EventQuery();
                eventQuery.setText(eventId);
                event = (CalendarEvent)calService.getEvents(username, eventQuery, null).get(0);
            } else {
                eventQuery = new EventQuery();
                eventQuery.setText(eventId);
                event = (CalendarEvent)calService.getPublicEvents(eventQuery).get(0);
            }
            if (event == null) {
                return Response.status((int)404).entity((Object)("Event " + eventId + "is removed")).cacheControl(cacheControl).build();
            }
            ByteArrayOutputStream out = icalEx.exportEventCalendar(event);
            ByteArrayInputStream in = new ByteArrayInputStream(((Object)out).toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + eventId + Utils.ICS_EXT)).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/feed/{username}/{feedname}/{filename}/")
    public Response feed(@PathParam(value="username") String username, @PathParam(value="feedname") String feedname, @PathParam(value="filename") String filename) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            FeedData feed = null;
            for (FeedData feedData : calService.getFeeds(username)) {
                if (!feedData.getTitle().equals(feedname)) continue;
                feed = feedData;
                break;
            }
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((InputStream)new ByteArrayInputStream(feed.getContent())));
            ArrayList entries = new ArrayList(syndFeed.getEntries());
            ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
            for (SyndEntry entry : entries) {
                String calendarId = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                ArrayList<String> calendarIds = new ArrayList<String>();
                calendarIds.add(calendarId);
                Calendar calendar = calService.getUserCalendar(username, calendarId);
                if (calendar != null) {
                    events.addAll(calService.getUserEventByCalendar(username, calendarIds));
                    continue;
                }
                try {
                    calendar = calService.getSharedCalendars(username, false).getCalendarById(calendarId);
                }
                catch (NullPointerException e) {
                    calendar = null;
                }
                if (calendar != null) {
                    events.addAll(calService.getSharedEventByCalendars(username, calendarIds));
                    continue;
                }
                calendar = calService.getGroupCalendar(calendarId);
                if (calendar == null) continue;
                EventQuery eventQuery = new EventQuery();
                eventQuery.setCalendarId(calendarIds.toArray(new String[0]));
                events.addAll(calService.getPublicEvents(eventQuery));
            }
            if (events.size() == 0) {
                return Response.status((int)404).entity((Object)("Feed " + feedname + "is removed")).cacheControl(cacheControl).build();
            }
            return Response.ok((Object)this.makeFeed(username, events, feed), (String)"application/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    private String makeFeed(String author, List<CalendarEvent> events, FeedData feedData) throws Exception {
        String baseURL = feedData.getUrl().split(BASE_RSS_URL)[0];
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(feedData.getTitle());
        feed.setLink(feedData.getUrl());
        feed.setDescription(feedData.getTitle());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (CalendarEvent event : events) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(event.getSummary());
            entry.setLink(baseURL + BASE_EVENT_URL + Utils.SLASH + author + Utils.SLASH + event.getId() + "splitter" + event.getCalType() + Utils.ICS_EXT);
            entry.setAuthor(author);
            SyndContentImpl description = new SyndContentImpl();
            description.setType(Utils.MIMETYPE_TEXTPLAIN);
            description.setValue(event.getDescription());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            entry.getEnclosures();
        }
        feed.setEntries(entries);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        String feedXML = output.outputString((SyndFeed)feed);
        feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
        return feedXML;
    }

    @GET
    @Path(value="/rss/{username}/{calendarId}/{type}/")
    public Response rss(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar cal = null;
            switch (Integer.parseInt(type)) {
                case 0: {
                    cal = calService.getUserCalendar(username, calendarId);
                    break;
                }
                case 2: {
                    cal = calService.getGroupCalendar(calendarId);
                    break;
                }
                case 1: {
                    cal = calService.getSharedCalendars(username, true).getCalendarById(calendarId);
                }
            }
            if (cal == null) {
                return Response.status((int)404).entity((Object)("Calendar " + calendarId + "is removed")).cacheControl(cacheControl).build();
            }
            if (cal.getPublicUrl() == null || cal.getPublicUrl().length() == 0) {
                return Response.status((int)204).entity((Object)("Calendar " + calendarId + "is not public rss")).cacheControl(cacheControl).build();
            }
            List events = calService.getUserEventByCalendar(username, Arrays.asList(calendarId));
            return Response.ok((Object)this.makeRss(username, cal, events), (String)"application/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    private String makeRss(String auhtor, Calendar cal, List<CalendarEvent> events) throws Exception {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(cal.getName());
        feed.setLink(cal.getPublicUrl());
        if (cal.getDescription() == null) {
            cal.setDescription("This is description");
        }
        feed.setDescription(cal.getDescription());
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (CalendarEvent e : events) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(e.getSummary());
            entry.setLink(cal.getPublicUrl().replaceFirst("rss", "subscribe") + Utils.SLASH + e.getId());
            entry.setAuthor(auhtor);
            SyndContentImpl description = new SyndContentImpl();
            description.setType(Utils.MIMETYPE_TEXTPLAIN);
            description.setValue(e.getDescription());
            entry.setDescription((SyndContent)description);
            entries.add(entry);
            entry.getEnclosures();
        }
        feed.setEntries(entries);
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        String feedXML = output.outputString((SyndFeed)feed);
        feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
        return feedXML;
    }

    @GET
    @Path(value="/subscribe/{username}/{calendarId}/{type}")
    public Response publicProcess(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            Calendar calendar = null;
            if (type.equals("0")) {
                calendar = calService.getUserCalendar(username, calendarId);
            } else if (type.equals("1")) {
                try {
                    calendar = calService.getSharedCalendars(username, false).getCalendarById(calendarId);
                }
                catch (NullPointerException ex) {}
            } else {
                try {
                    calendar = calService.getGroupCalendar(calendarId);
                }
                catch (PathNotFoundException ex) {
                    // empty catch block
                }
            }
            if (calendar == null || Utils.isEmpty((String)calendar.getPublicUrl())) {
                return Response.status((int)423).entity((Object)("Calendar " + calendarId + " is not public access")).cacheControl(cacheControl).build();
            }
            CalendarImportExport icalEx = calService.getCalendarImportExports(CalendarService.ICALENDAR);
            OutputStream out = icalEx.exportCalendar(username, Arrays.asList(calendarId), type);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (NullPointerException ne) {
            return Response.ok(null, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="private/{username}/{calendarId}/{type}")
    public Response privateProcess(@PathParam(value="username") String username, @PathParam(value="calendarId") String calendarId, @PathParam(value="type") String type) throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
            CalendarImportExport icalEx = calService.getCalendarImportExports(CalendarService.ICALENDAR);
            OutputStream out = icalEx.exportCalendar(username, Arrays.asList(calendarId), type);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toString().getBytes());
            return Response.ok((Object)in, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (NullPointerException ne) {
            return Response.ok(null, (String)"text/calendar").header("Cache-Control", (Object)"private max-age=600, s-maxage=120").header("Content-Disposition", (Object)("attachment;filename=\"" + calendarId + ".ics")).cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)e).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="/searchCalendar/{keywords}")
    @Produces(value={"application/json"})
    public Response searchCalendar(@PathParam(value="keywords") String keywords) throws Exception {
        CalendarService calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
        ArrayList<String> calendarNames = new ArrayList<String>();
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            if (ConversationState.getCurrent().getIdentity() == null) {
                return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
            }
            String username = ConversationState.getCurrent().getIdentity().getUserId();
            if (username == null) {
                return Response.ok((Object)Response.Status.UNAUTHORIZED).cacheControl(cacheControl).build();
            }
            ResourceBundle resourceBundle = calendarService.getResourceBundle();
            for (Calendar cal : calendarService.getUserCalendars(username, true)) {
                if (cal.getId().equals(Utils.getDefaultCalendarId((String)username)) && cal.getName().equals("defaultCalendarName")) {
                    String newName = resourceBundle.getString("UICalendars.label.defaultCalendarId");
                    cal.setName(newName);
                }
                if (!cal.getName().toLowerCase().contains(keywords)) continue;
                calendarNames.add(0 + Utils.COLON + cal.getId() + Utils.COLON + cal.getName());
            }
            List groupCals = calendarService.getGroupCalendars(this.getUserGroups(username), true, username);
            for (GroupCalendarData groupData : groupCals) {
                if (groupData == null) continue;
                for (Calendar cal : groupData.getCalendars()) {
                    if (!cal.getName().toLowerCase().contains(keywords)) continue;
                    calendarNames.add(2 + Utils.COLON + cal.getId() + Utils.COLON + cal.getName());
                }
            }
            GroupCalendarData sharedData = calendarService.getSharedCalendars(username, true);
            if (sharedData != null) {
                for (Calendar cal : sharedData.getCalendars()) {
                    if (cal.getId().equals(Utils.getDefaultCalendarId((String)cal.getCalendarOwner())) && cal.getName().equals("defaultCalendarName")) {
                        String newName = resourceBundle.getString("UICalendars.label.defaultCalendarId");
                        cal.setName(Utils.getDisplaySharedCalendar((String)cal.getCalendarOwner(), (String)newName));
                    }
                    if (!cal.getName().toLowerCase().contains(keywords)) continue;
                    calendarNames.add(1 + Utils.COLON + cal.getId() + Utils.COLON + cal.getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.ok((Object)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(cacheControl).build();
        }
        CalendarData data = new CalendarData();
        data.setInfo(calendarNames);
        return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
    }

    private final String[] getUserGroups(String username) throws Exception {
        this.start();
        OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        Object[] objGroupIds = oService.getGroupHandler().findGroupsOfUser(username).toArray();
        ArrayList<String> listGroupIds = new ArrayList<String>();
        for (Object object : objGroupIds) {
            listGroupIds.add(((Group)object).getId());
        }
        this.stop();
        return listGroupIds.toArray(new String[0]);
    }
}

