/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class KeywordTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private boolean done = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public KeywordTokenizer(Reader input) {
        this(input, 256);
    }

    public KeywordTokenizer(Reader input, int bufferSize) {
        super(input);
    }

    public Token next(Token reusableToken) throws IOException {
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        if (!this.done) {
            int length;
            this.done = true;
            int upto = 0;
            reusableToken.clear();
            char[] buffer = reusableToken.termBuffer();
            while ((length = this.input.read(buffer, upto, buffer.length - upto)) != -1) {
                if ((upto += length) != buffer.length) continue;
                buffer = reusableToken.resizeTermBuffer(1 + buffer.length);
            }
            reusableToken.setTermLength(upto);
            return reusableToken;
        }
        return null;
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.done = false;
    }

    static {
        $assertionsDisabled = !KeywordTokenizer.class.desiredAssertionStatus();
    }
}

