/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import org.jcrom.JcrMappingException;
import org.jcrom.Mapper;
import org.jcrom.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jcrom {
    private final Mapper mapper;

    public Jcrom() {
        this(true);
    }

    public Jcrom(boolean cleanNames) {
        this(cleanNames, false);
    }

    public Jcrom(boolean cleanNames, boolean dynamicInstantiation) {
        this(cleanNames, dynamicInstantiation, new HashSet<Class>());
    }

    public Jcrom(Set<Class> classesToMap) {
        this(true, false, classesToMap);
    }

    public Jcrom(boolean cleanNames, Set<Class> classesToMap) {
        this(cleanNames, false, classesToMap);
    }

    public Jcrom(boolean cleanNames, boolean dynamicInstantiation, Set<Class> classesToMap) {
        this.mapper = new Mapper(cleanNames, dynamicInstantiation);
        for (Class c : classesToMap) {
            this.map(c);
        }
    }

    public synchronized Jcrom map(Class entityClass) {
        if (!this.mapper.isMapped(entityClass)) {
            Set<Class> validClasses = Validator.validate(entityClass, this.mapper.isDynamicInstantiation());
            for (Class c : validClasses) {
                this.mapper.addMappedClass(c);
            }
        }
        return this;
    }

    public Set<Class> getMappedClasses() {
        return Collections.unmodifiableSet(this.mapper.getMappedClasses());
    }

    public boolean isMapped(Class entityClass) {
        return this.mapper.isMapped(entityClass);
    }

    public String getName(Object object) throws JcrMappingException {
        try {
            return this.mapper.getNodeName(object);
        }
        catch (Exception e) {
            throw new JcrMappingException("Could not get node name from object", e);
        }
    }

    public String getPath(Object object) throws JcrMappingException {
        try {
            return this.mapper.getNodePath(object);
        }
        catch (Exception e) {
            throw new JcrMappingException("Could not get node path from object", e);
        }
    }

    public void setBaseVersionInfo(Object object, String name, Calendar created) throws JcrMappingException {
        try {
            this.mapper.setBaseVersionInfo(object, name, created);
        }
        catch (Exception e) {
            throw new JcrMappingException("Could not set base version info on object", e);
        }
    }

    public <T> T fromNode(Class<T> entityClass, Node node) throws JcrMappingException {
        return this.fromNode(entityClass, node, "*", -1);
    }

    public <T> T fromNode(Class<T> entityClass, Node node, String childNodeFilter, int maxDepth) throws JcrMappingException {
        if (!this.mapper.isDynamicInstantiation() && !this.mapper.isMapped(entityClass)) {
            throw new JcrMappingException("Trying to map to an unmapped class: " + entityClass.getName());
        }
        try {
            return (T)this.mapper.fromNode(entityClass, node, childNodeFilter, maxDepth);
        }
        catch (Exception e) {
            throw new JcrMappingException("Could not map from node", e);
        }
    }

    public Node addNode(Node parentNode, Object entity) throws JcrMappingException {
        return this.addNode(parentNode, entity, null);
    }

    public Node addNode(Node parentNode, Object entity, String[] mixinTypes) throws JcrMappingException {
        if (!this.mapper.isMapped(entity.getClass())) {
            throw new JcrMappingException("Trying to map an unmapped class: " + entity.getClass().getName());
        }
        try {
            return this.mapper.addNode(parentNode, entity, mixinTypes);
        }
        catch (Exception e) {
            throw new JcrMappingException("Could not create node from object", e);
        }
    }

    public String updateNode(Node node, Object entity) throws JcrMappingException {
        return this.updateNode(node, entity, "*", -1);
    }

    public String updateNode(Node node, Object entity, String childNodeFilter, int maxDepth) throws JcrMappingException {
        if (!this.mapper.isMapped(entity.getClass())) {
            throw new JcrMappingException("Trying to map an unmapped class: " + entity.getClass().getName());
        }
        try {
            return this.mapper.updateNode(node, entity, childNodeFilter, maxDepth);
        }
        catch (Exception e) {
            throw new JcrMappingException("Could not update node from object", e);
        }
    }
}

