/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.impl.CalendarEventListener;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

public class CalendarSpaceActivityPublisher
extends CalendarEventListener {
    private Log LOG = ExoLogger.getLogger(CalendarSpaceActivityPublisher.class);

    public void savePublicEvent(CalendarEvent event, String calendarId) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            if (calendarId == null || calendarId.indexOf("CalendarInSpace") < 0) {
                return;
            }
            String msg = "A new event has been added : " + event.getSummary();
            String body = event.getDescription();
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            String spaceId = calendarId.split("CalendarInSpace")[1];
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Can not record Activity for space when event added " + e.getMessage()));
        }
    }

    public void updatePublicEvent(CalendarEvent event, String calendarId) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            if (calendarId == null || calendarId.indexOf("CalendarInSpace") < 0) {
                return;
            }
            String msg = "The following event has been updated: " + event.getSummary();
            String body = event.getDescription();
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            String spaceId = calendarId.split("CalendarInSpace")[1];
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, "exosocial:spaces", msg, body);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Can not record Activity for space when event updated " + e.getMessage()));
        }
    }
}

