/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.aspects;

import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.TransportGuarantee;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.SecurityInfo;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.InsufficientTransportGuaranteeResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.container.PortletContainer;

public class SecureTransportInterceptor
extends PortletInvokerInterceptor {
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        PortletContainer container = (PortletContainer)invocation.getAttribute("PORTLET_CONTAINER");
        PortletInfo containerInfo = container.getInfo();
        SecurityInfo securityInfo = containerInfo.getSecurity();
        SecurityContext securityContext = invocation.getSecurityContext();
        boolean invoke = true;
        if (!securityContext.isSecure()) {
            if (securityInfo.containsTransportGuarantee(TransportGuarantee.CONFIDENTIAL)) {
                invoke = false;
            } else if (securityInfo.containsTransportGuarantee(TransportGuarantee.INTEGRAL)) {
                invoke = false;
            }
        }
        if (invoke) {
            return super.invoke(invocation);
        }
        return new InsufficientTransportGuaranteeResponse();
    }
}

