/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.common.InitParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFactory {
    private Map<Class<?>, Object> services;

    public Map<Class<?>, Object> getServices() {
        return this.services;
    }

    private void setService(Object object) throws Exception {
        Field[] fields;
        Class<?> clazz = object.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Object value = this.services.get(field.getType());
            if (value == null) continue;
            field.setAccessible(true);
            field.set(object, value);
        }
    }

    public void set(List<Class<?>> classes, Map<Class<?>, Object> map) throws Exception {
        Object obj;
        Class<?> clazz;
        this.services = map;
        Iterator<Class<?>> iter = classes.iterator();
        while (iter.hasNext()) {
            clazz = iter.next();
            obj = this.createInitConstructor(clazz);
            if (obj == null) continue;
            iter.remove();
        }
        iter = classes.iterator();
        while (iter.hasNext()) {
            clazz = iter.next();
            obj = this.createEmptyConstructor(clazz);
            if (obj == null) continue;
            iter.remove();
        }
        iter = classes.iterator();
        while (iter.hasNext()) {
            clazz = iter.next();
            obj = this.createParamsConstructor(clazz);
            if (obj == null) continue;
            iter.remove();
        }
        Iterator<Class<?>> iterator = this.services.keySet().iterator();
        while (iterator.hasNext()) {
            this.setService(this.services.get(iterator.next()));
        }
    }

    public Object createService(Class<?> clazz, Map<Class<?>, Object> map) throws Exception {
        this.services = map;
        return this.createService(clazz);
    }

    private Object createService(Class<?> clazz) throws Exception {
        Object obj = this.createInitConstructor(clazz);
        if (obj == null) {
            obj = this.createEmptyConstructor(clazz);
        }
        if (obj == null) {
            obj = this.createParamsConstructor(clazz);
        }
        if (obj == null) {
            throw new Exception("Can't create new Object for " + clazz.getName() + " \n declare constructor for this class. ");
        }
        this.setService(obj);
        this.services.put(clazz, obj);
        return obj;
    }

    private Object createEmptyConstructor(Class<?> clazz) throws Exception {
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException exp) {
            return null;
        }
        if (constructor == null) {
            return null;
        }
        constructor.setAccessible(true);
        Object value = constructor.newInstance(new Object[0]);
        this.services.put(clazz, value);
        return value;
    }

    private Object createInitConstructor(Class<?> clazz) throws Exception {
        Constructor<?> ele;
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Constructor<?> constructor = null;
        InitParams init = null;
        Constructor<?>[] arr$ = constructors;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (init = (ele = arr$[i$]).getAnnotation(InitParams.class)) == null; ++i$) {
        }
        if (constructor == null) {
            return null;
        }
        return this.createParamsConstructor(clazz, constructor, init.value());
    }

    private Object createParamsConstructor(Class clazz) throws Exception {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors == null || constructors.length < 1) {
            return null;
        }
        Constructor<?> constructor = constructors[0];
        Class[] classes = constructor.getParameterTypes();
        return this.createParamsConstructor(clazz, constructor, classes);
    }

    private Object createParamsConstructor(Class clazz, Constructor<?> constructor, Class[] classes) throws Exception {
        Object[] objs = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Object obj = this.services.get(classes[i]);
            if (obj == null) {
                Constructor cons = classes[i].getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                obj = cons.newInstance(new Object[0]);
            }
            objs[i] = obj;
        }
        constructor.setAccessible(true);
        Object value = constructor.newInstance(objs);
        this.services.put(clazz, value);
        return value;
    }
}

