/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gatein.common.io.Serialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SerializationFilter {
    public static final SerializationFilter TRIVIAL = new SerializationFilter(){

        @Override
        public <T> void serialize(Serialization<T> serialization, T t, OutputStream out) throws IllegalArgumentException, IOException {
            serialization.serialize(t, out);
        }

        @Override
        public <T> T unserialize(Serialization<T> serialization, InputStream in) throws IllegalArgumentException, IOException {
            return serialization.unserialize(in);
        }
    };
    public static final SerializationFilter COMPRESSOR = new SerializationFilter(){

        @Override
        public <T> void serialize(Serialization<T> serialization, T t, OutputStream out) throws IllegalArgumentException, IOException {
            GZIPOutputStream zos = new GZIPOutputStream(out);
            serialization.serialize(t, zos);
            zos.finish();
        }

        @Override
        public <T> T unserialize(Serialization<T> serialization, InputStream in) throws IllegalArgumentException, IOException {
            GZIPInputStream zis = new GZIPInputStream(in);
            return serialization.unserialize(zis);
        }
    };

    public <T> void serialize(Serialization<T> var1, T var2, OutputStream var3) throws IllegalArgumentException, IOException;

    public <T> T unserialize(Serialization<T> var1, InputStream var2) throws IllegalArgumentException, IOException;
}

