/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import java.util.HashMap;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.impl.CalendarEventListener;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;

public class CalendarSpaceActivityPublisher
extends CalendarEventListener {
    private Log LOG = ExoLogger.getLogger(CalendarSpaceActivityPublisher.class);
    public static final String CALENDAR_APP_ID = "cs-calendar:spaces";
    public static final String EVENT_ADDED = "EventAdded".intern();
    public static final String EVENT_UPDATED = "EventUpdated".intern();
    public static final String EVENT_ID_KEY = "EventID".intern();
    public static final String CALENDAR_ID_KEY = "CalendarID".intern();
    public static final String TASK_ADDED = "TaskAdded".intern();
    public static final String TASK_UPDATED = "TaskUpdated".intern();
    public static final String EVENT_TYPE_KEY = "EventType".intern();
    public static final String EVENT_SUMMARY_KEY = "EventSummary".intern();
    public static final String EVENT_TITLE_KEY = "EventTitle".intern();
    public static final String EVENT_DESCRIPTION_KEY = "EventDescription".intern();
    public static final String EVENT_LOCALE_KEY = "EventLocale".intern();
    public static final String EVENT_STARTTIME_KEY = "EventStartTime".intern();
    public static final String EVENT_ENDTIME_KEY = "EventEndTime".intern();

    public void savePublicEvent(CalendarEvent event, String calendarId) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            if (calendarId == null || calendarId.indexOf("CalendarInSpace") < 0) {
                return;
            }
            Activity activity = new Activity();
            String eventType = event.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) ? EVENT_ADDED : TASK_ADDED;
            activity.setTitle(event.getSummary());
            activity.setBody(event.getDescription());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(EVENT_TYPE_KEY, eventType);
            params.put(EVENT_ID_KEY, event.getId());
            params.put(CALENDAR_ID_KEY, calendarId);
            params.put(EVENT_SUMMARY_KEY, event.getSummary());
            params.put(EVENT_LOCALE_KEY, event.getLocation() != null ? event.getLocation() : "");
            params.put(EVENT_DESCRIPTION_KEY, event.getDescription() != null ? event.getDescription() : "");
            params.put(EVENT_STARTTIME_KEY, String.valueOf(event.getFromDateTime().getTime()));
            params.put(EVENT_ENDTIME_KEY, String.valueOf(event.getToDateTime().getTime()));
            activity.setType(CALENDAR_APP_ID);
            activity.setTemplateParams(params);
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            String spaceId = calendarId.split("CalendarInSpace")[1];
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, activity);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Can not record Activity for space when event added " + e.getMessage()));
        }
    }

    public void updatePublicEvent(CalendarEvent event, String calendarId) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            if (calendarId == null || calendarId.indexOf("CalendarInSpace") < 0) {
                return;
            }
            Activity activity = new Activity();
            activity.setTitle(event.getSummary());
            activity.setBody(event.getDescription());
            HashMap<String, String> params = new HashMap<String, String>();
            String eventType = event.getEventType().equalsIgnoreCase(CalendarEvent.TYPE_EVENT) ? EVENT_UPDATED : TASK_UPDATED;
            params.put(EVENT_TYPE_KEY, eventType);
            params.put(EVENT_ID_KEY, event.getId());
            params.put(CALENDAR_ID_KEY, calendarId);
            params.put(EVENT_SUMMARY_KEY, event.getSummary());
            params.put(EVENT_LOCALE_KEY, event.getLocation() != null ? event.getLocation() : "");
            params.put(EVENT_DESCRIPTION_KEY, event.getDescription() != null ? event.getDescription() : "");
            params.put(EVENT_STARTTIME_KEY, String.valueOf(event.getFromDateTime().getTime()));
            params.put(EVENT_ENDTIME_KEY, String.valueOf(event.getToDateTime().getTime()));
            activity.setType(CALENDAR_APP_ID);
            activity.setTemplateParams(params);
            IdentityManager indentityM = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
            String spaceId = calendarId.split("CalendarInSpace")[1];
            Identity spaceIdentity = indentityM.getOrCreateIdentity("space", spaceId, false);
            activityM.recordActivity(spaceIdentity, activity);
        }
        catch (Exception e) {
            this.LOG.error((Object)("Can not record Activity for space when event updated " + e.getMessage()));
        }
    }
}

