/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.jcr.model;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.PropertyDefinition;

public class PropertyData {
    private String id_;
    private String name_;
    private Object value_;
    private Object stream_;
    private PropertyDefinition def_;
    private boolean residual_;
    private int type_;
    private boolean newDataRead_ = true;

    public PropertyData(PropertyDefinition def) {
        this.def_ = def;
        this.name_ = def.getName();
        this.id_ = Integer.toString(this.hashCode());
        this.residual_ = "*".equals(this.name_);
        this.type_ = def.getRequiredType();
    }

    public String getId() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String s) {
        this.name_ = s;
    }

    public int getPropertyType() {
        return this.type_;
    }

    public void setPropertyType(int type) {
        this.type_ = type;
    }

    public PropertyDefinition getPropertyDef() {
        return this.def_;
    }

    public boolean isResidual() {
        return this.residual_;
    }

    public boolean isMultiple() {
        return this.def_.isMultiple();
    }

    public Object getValue() {
        return this.value_;
    }

    public boolean hasValue() {
        return this.value_ != null;
    }

    public void setValue(byte[] value) throws Exception {
        this.value_ = "";
        this.stream_ = value;
    }

    public void setValue(String value) throws Exception {
        if (this.isMultiple()) {
            ArrayList<String> list = (ArrayList<String>)this.value_;
            if (list == null) {
                this.value_ = list = new ArrayList<String>(3);
            }
            if (this.newDataRead_) {
                list.clear();
            }
            this.newDataRead_ = false;
            if (value != null && value.length() > 0) {
                list.add(value);
            }
        } else {
            this.value_ = value;
        }
    }

    public void setValue(Node node) throws Exception {
        Property prop = node.getProperty(this.name_);
        if (this.isMultiple()) {
            Value[] values = prop.getValues();
            ArrayList<String> temp = new ArrayList<String>(3);
            for (Value value : values) {
                if (this.getPropertyType() == 2) {
                    temp.add("");
                    continue;
                }
                temp.add(value.getString());
            }
            this.value_ = temp;
        } else {
            this.value_ = this.getPropertyType() == 2 ? "" : prop.getValue().getString();
        }
    }

    public String getValueAsString() {
        return (String)this.value_;
    }

    public List getValuesAsString() {
        this.newDataRead_ = true;
        return (List)this.value_;
    }

    public Value getPropertyValue(ValueFactory factory) throws Exception {
        if (this.getPropertyType() != 2) {
            return factory.createValue((String)this.value_, this.getPropertyType());
        }
        return factory.createValue(new String((byte[])this.stream_), this.getPropertyType());
    }

    public Value[] getPropertyValues(ValueFactory factory) throws Exception {
        this.newDataRead_ = true;
        List values = (List)this.value_;
        if (values == null || values.size() == 0) {
            return null;
        }
        Value[] value = new Value[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            String s = (String)values.get(i);
            value[i] = this.getPropertyType() != 2 ? factory.createValue(s, this.getPropertyType()) : factory.createValue(new String((byte[])this.stream_), this.getPropertyType());
        }
        return value;
    }
}

