/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.spell.Dictionary;

public class LuceneDictionary
implements Dictionary {
    private IndexReader reader;
    private String field;

    public LuceneDictionary(IndexReader reader, String field) {
        this.reader = reader;
        this.field = field.intern();
    }

    public final Iterator getWordsIterator() {
        return new LuceneIterator();
    }

    final class LuceneIterator
    implements Iterator {
        private TermEnum termEnum;
        private Term actualTerm;
        private boolean hasNextCalled;

        LuceneIterator() {
            try {
                this.termEnum = LuceneDictionary.this.reader.terms(new Term(LuceneDictionary.this.field));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Object next() {
            if (!this.hasNextCalled) {
                this.hasNext();
            }
            this.hasNextCalled = false;
            try {
                this.termEnum.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.actualTerm != null ? this.actualTerm.text() : null;
        }

        public boolean hasNext() {
            if (this.hasNextCalled) {
                return this.actualTerm != null;
            }
            this.hasNextCalled = true;
            this.actualTerm = this.termEnum.term();
            if (this.actualTerm == null) {
                return false;
            }
            String currentField = this.actualTerm.field();
            if (currentField != LuceneDictionary.this.field) {
                this.actualTerm = null;
                return false;
            }
            return true;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

