/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerCacheLoader
implements CacheLoader {
    private final CacheLoader cl;
    private CacheSPI cache;
    private CacheLoaderConfig.IndividualCacheLoaderConfig config;

    public ControllerCacheLoader(CacheLoader cl) {
        this.cl = cl;
    }

    public void commit(Object tx) throws Exception {
        this.cl.commit(tx);
    }

    public boolean exists(Fqn name) throws Exception {
        if (this.cache.getCacheStatus() == CacheStatus.STARTING) {
            NodeSPI node = this.cache.peek(name, false);
            if (node != null) {
                return true;
            }
            return this.cl.exists(name);
        }
        return false;
    }

    public Map<Object, Object> get(Fqn name) throws Exception {
        if (this.cache.getCacheStatus() == CacheStatus.STARTING) {
            NodeSPI node = this.cache.peek(name, false);
            if (node != null) {
                return node.getDataDirect();
            }
            return this.cl.get(name);
        }
        return null;
    }

    public Set<?> getChildrenNames(Fqn fqn) throws Exception {
        return this.cl.getChildrenNames(fqn);
    }

    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    public void loadEntireState(ObjectOutputStream os) throws Exception {
        this.cl.loadEntireState(os);
    }

    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        this.cl.loadState(subtree, os);
    }

    public void prepare(Object tx, List<Modification> modifications, boolean onePhase) throws Exception {
        this.cl.prepare(tx, modifications, onePhase);
    }

    public void put(List<Modification> modifications) throws Exception {
        this.cl.put(modifications);
    }

    public void put(Fqn name, Map<Object, Object> attributes) throws Exception {
        this.cl.put(name, attributes);
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        return this.cl.put(name, key, value);
    }

    public void remove(Fqn fqn) throws Exception {
        this.cl.remove(fqn);
    }

    public Object remove(Fqn fqn, Object key) throws Exception {
        return this.cl.remove(fqn, key);
    }

    public void removeData(Fqn fqn) throws Exception {
        this.cl.removeData(fqn);
    }

    public void rollback(Object tx) {
        this.cl.rollback(tx);
    }

    public void setCache(CacheSPI c) {
        this.cl.setCache(c);
        this.cache = c;
    }

    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        this.config = config;
    }

    public void setRegionManager(RegionManager manager) {
        this.cl.setRegionManager(manager);
    }

    public void storeEntireState(ObjectInputStream is) throws Exception {
        this.cl.storeEntireState(is);
    }

    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        this.cl.storeState(subtree, is);
    }

    public void create() throws Exception {
        this.cl.create();
    }

    public void destroy() {
        this.cl.destroy();
    }

    public void start() throws Exception {
        this.cl.start();
    }

    public void stop() {
        this.cl.stop();
    }
}

