/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class ContentRewriterFeatureFactory {
    private final GadgetSpecFactory specFactory;
    private Map<String, ContentRewriterFeature> contentRewriters;
    static final String CONTENT_REWRITE_KEY = "gadgets.content-rewrite";
    static final String INCLUDE_TAGS_KEY = "include-tags";
    static final String INCLUDE_URLS_KEY = "include-urls";
    static final String EXCLUDE_TAGS_KEY = "exclude-urls";
    static final String EXPIRES_KEY = "expires";
    private final ContainerConfig config;

    @Inject
    public ContentRewriterFeatureFactory(GadgetSpecFactory specFactory, ContainerConfig config) {
        this.specFactory = specFactory;
        this.config = config;
        this.contentRewriters = new HashMap<String, ContentRewriterFeature>();
    }

    public ContentRewriterFeature getDefault(String container) {
        if (!this.contentRewriters.containsKey(container)) {
            this.contentRewriters.put(container, this.createContentRewriterFeature(null, container));
        }
        return this.contentRewriters.get(container);
    }

    public ContentRewriterFeature get(HttpRequest request) {
        final Uri gadgetUri = request.getGadget();
        if (gadgetUri != null) {
            try {
                GadgetContext context = new GadgetContext(){

                    public Uri getUrl() {
                        return gadgetUri;
                    }
                };
                GadgetSpec spec = this.specFactory.getGadgetSpec(context);
                if (spec != null) {
                    return this.get(spec, request.getContainer());
                }
            }
            catch (GadgetException ge) {
                // empty catch block
            }
        }
        return this.getDefault(request.getContainer());
    }

    private ContentRewriterFeature createContentRewriterFeature(GadgetSpec spec, String container) {
        Object object = this.config.getProperty(container, CONTENT_REWRITE_KEY);
        HashSet<String> tags = new HashSet<String>();
        if (object instanceof JSONObject) {
            try {
                JSONObject contentRewrite = (JSONObject)object;
                JSONArray jsonTags = contentRewrite.getJSONArray(INCLUDE_TAGS_KEY);
                int j = jsonTags.length();
                for (int i = 0; i < j; ++i) {
                    tags.add(jsonTags.getString(i).toLowerCase());
                }
                return new ContentRewriterFeature(spec, contentRewrite.getString(INCLUDE_URLS_KEY), contentRewrite.getString(EXCLUDE_TAGS_KEY), contentRewrite.getString(EXPIRES_KEY), tags);
            }
            catch (JSONException e) {
                return null;
            }
        }
        ImmutableMap contentRewrite = (ImmutableMap)object;
        ImmutableList tagsList = (ImmutableList)contentRewrite.get((Object)INCLUDE_TAGS_KEY);
        for (String tag : tagsList) {
            tags.add(tag.toString().toLowerCase());
        }
        return new ContentRewriterFeature(spec, (String)contentRewrite.get((Object)INCLUDE_URLS_KEY), (String)contentRewrite.get((Object)EXCLUDE_TAGS_KEY), (String)contentRewrite.get((Object)EXPIRES_KEY), tags);
    }

    public ContentRewriterFeature get(GadgetSpec spec, String container) {
        ContentRewriterFeature rewriterFeature = (ContentRewriterFeature)spec.getAttribute("content-rewriter");
        if (rewriterFeature != null) {
            return rewriterFeature;
        }
        rewriterFeature = this.createContentRewriterFeature(spec, container);
        spec.setAttribute("content-rewriter", rewriterFeature);
        return rewriterFeature;
    }

    public ContentRewriterFeature createRewriteAllFeature(int ttl) {
        return new ContentRewriterFeature(null, ".*", "", ttl == -1 ? "HTTP" : Integer.toString(ttl), Collections.<String>emptySet());
    }
}

