/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api;

import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SystemInfo {
    private static final String HW_PHYSMEM = "hw.physmem";
    private static long physicalMemoryCache = -1L;

    public static long getFreeDiskSpace(File file) {
        block7: {
            for (file = file.getAbsoluteFile(); file != null && !file.exists(); file = file.getParentFile()) {
            }
            if (file != null) {
                try {
                    if (Util.isWindows()) {
                        return Misc.getFreeDiskSpace(file);
                    }
                    if (!Util.isMacOS() && !Util.isLinux()) break block7;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (!Execution.executeAndWait(new String[]{"df", "-k", file.getAbsolutePath()}, stringBuffer)) break block7;
                    String string = stringBuffer.toString().trim();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                    stringTokenizer.nextToken();
                    String string2 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t\f");
                    try {
                        stringTokenizer2.nextToken();
                        stringTokenizer2.nextToken();
                        stringTokenizer2.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        string2 = stringTokenizer.nextToken();
                        stringTokenizer2 = new StringTokenizer(string2, " \t\f");
                        stringTokenizer2.nextToken();
                        stringTokenizer2.nextToken();
                    }
                    return Long.parseLong(stringTokenizer2.nextToken()) * 1024L;
                }
                catch (Exception exception) {
                    System.err.println("Could not determine disk space: " + exception.getMessage());
                }
            }
        }
        return -1L;
    }

    public static long getPhysicalMemory() {
        if (physicalMemoryCache == -1L) {
            physicalMemoryCache = SystemInfo.initPhysicalMemory();
        }
        return physicalMemoryCache;
    }

    private static long initPhysicalMemory() {
        try {
            if (Util.isWindows()) {
                return Misc.getPhysicalMemory();
            }
            if (Util.isMacOS()) {
                String string;
                String string2;
                StringBuffer stringBuffer = new StringBuffer();
                if (Execution.executeAndWait(new String[]{"sysctl", HW_PHYSMEM}, stringBuffer) && (string2 = stringBuffer.toString().trim()).startsWith(string = "hw.physmem: ")) {
                    return Long.parseLong(string2.substring(string.length()));
                }
            } else if (Util.isLinux()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader("/proc/meminfo"));
                String string = bufferedReader.readLine();
                bufferedReader.close();
                String string3 = "MemTotal: ";
                if (string != null && (string = string.trim()).startsWith(string3) && string.length() > string3.length() + 2) {
                    string = string.substring(string3.length(), string.length() - 2).trim();
                    return Long.parseLong(string) * 1024L;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0L;
    }
}

