/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.ApplicationRegistry;
import com.install4j.api.SystemInfo;
import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InstallationDirectoryScreen
extends SystemScreen
implements DirectorySelector.InternalValidator {
    private boolean showRequiredDiskSpace = true;
    private boolean suggestAppDir = true;
    private boolean existingDirWarning = true;
    private boolean validateApplicationId = true;
    private DirectorySelector directorySelector;
    private boolean initialized;
    private JLabel lblSpace;

    public InstallationDirectoryScreen() {
        InstallerVariables.registerResponseFileVariable("sys.installationDir");
    }

    public boolean isShowRequiredDiskSpace() {
        return this.showRequiredDiskSpace;
    }

    public void setShowRequiredDiskSpace(boolean bl) {
        this.showRequiredDiskSpace = bl;
    }

    public boolean isSuggestAppDir() {
        return this.suggestAppDir;
    }

    public void setSuggestAppDir(boolean bl) {
        this.suggestAppDir = bl;
    }

    public boolean isExistingDirWarning() {
        return this.existingDirWarning;
    }

    public void setExistingDirWarning(boolean bl) {
        this.existingDirWarning = bl;
    }

    public boolean isValidateApplicationId() {
        return this.validateApplicationId;
    }

    public void setValidateApplicationId(boolean bl) {
        this.validateApplicationId = bl;
    }

    public boolean handleUnattended() {
        File file = this.validateInternally(this.getInstallerContext().getInstallationDirectory());
        if (file == null || !InstallerUtil.checkWritable(file, null, true)) {
            System.out.println("You can set the destination directory by passing \"-dir [directory]\".");
            return false;
        }
        this.getInstallerContext().setInstallationDirectory(file);
        return true;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        while (true) {
            String string = this.getContext().getInstallationDirectory().getAbsolutePath();
            String string2 = console.askString(MessageFormat.format(this.getMessage("SelectDirDesc"), this.getApplicationName()), string);
            try {
                File file = new File(string2).getCanonicalFile();
                if (!new File(string2).isAbsolute() || file.exists() && !file.isDirectory()) {
                    console.println(MessageFormat.format(this.getMessage("InvalidDirectory"), string2));
                    continue;
                }
                if ((file = this.validateInternally(file)) == null || !InstallerUtil.checkWritable(file, null, true)) continue;
                InstallerConfig.getCurrentInstance().setInstallationDirectory(file);
                return true;
            }
            catch (IOException iOException) {
                console.println(MessageFormat.format(this.getMessage("InvalidDirectory"), string2));
                continue;
            }
            break;
        }
    }

    public void willActivate() {
        super.willActivate();
        this.initDirectorySelector();
        this.updateSpaceLabel();
    }

    private void initDirectorySelector() {
        if (!this.initialized) {
            String string;
            File file;
            File file2 = this.getContext().getInstallationDirectory();
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            if (!(!this.suggestAppDir || installerConfig.getInstallerType() == 2 || Util.isMacosInstaller() && installerConfig.getMacSpecificConfig().isSingleBundle())) {
                file = file2.getParentFile();
                string = file2.getName();
            } else {
                file = file2;
                string = null;
            }
            if (file == null) {
                file = file2;
                string = installerConfig.getApplicationName();
            }
            this.directorySelector.initDirectory(file, string);
            this.directorySelector.setNoStandardDirectoryNameForUpdate(true);
            this.initialized = true;
        }
    }

    public void activated() {
        super.activated();
        this.directorySelector.focusTextField();
    }

    protected boolean checkCompleted() {
        boolean bl;
        boolean bl2 = bl = this.directorySelector.checkSelectedDirectory() && super.checkCompleted();
        if (bl) {
            File file = this.getSelectedDir();
            InstallerConfig.getCurrentInstance().setInstallationDirectory(file);
            return InstallerUtil.checkWritable(file, Util.getParentWindow(), true);
        }
        return false;
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(MessageFormat.format(this.getMessage("SelectDirLabel"), this.getApplicationName()), jPanel, gridBagConstraints);
        gridBagConstraints.insets.top = 25;
        jPanel.add((Component)this.directorySelector, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        if (this.showRequiredDiskSpace) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            this.lblSpace = new JLabel();
            this.updateSpaceLabel();
            jPanel.add((Component)this.lblSpace, gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
    }

    private void updateSpaceLabel() {
        if (this.lblSpace != null) {
            String string = MessageFormat.format(this.getMessage("DiskSpaceMBLabel"), this.getDiskSpaceMB());
            this.lblSpace.setText(string);
        }
    }

    public boolean isFillVertical() {
        return false;
    }

    private String getDiskSpaceMB() {
        double d = (double)ContentInstaller.getInstance().getMinSize() / 1048576.0;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format(d);
    }

    protected int getMaxGridWidth() {
        return 2;
    }

    public String getTitle() {
        return this.getMessage("WizardSelectDir");
    }

    public String getSubTitle() {
        return MessageFormat.format(this.getMessage("SelectDirDesc"), this.getApplicationName());
    }

    protected void setupControls() {
        super.setupControls();
        this.directorySelector = new DirectorySelector(this.getMessage("ReadyMemoDir").replace(':', ' ').trim(), false);
        this.directorySelector.setInternalValidator(this);
        this.directorySelector.activateNextScreenOnEnter(this.getContext().getWizardContext());
    }

    public File validateInternally(File file) {
        boolean bl;
        ResourceBundle resourceBundle = Messages.getMessages();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        boolean bl2 = bl = !Util.isMacosInstaller() || !installerConfig.getMacSpecificConfig().isSingleBundle();
        if (this.validateApplicationId && bl && !ApplicationRegistry.checkApplicationId(file)) {
            if (installerConfig.getInstallerType() == 1) {
                GUIHelper.showMessage(Util.getParentWindow(), resourceBundle.getString("DifferentApplication"), 1);
            } else {
                File file2;
                if (Util.isMacosInstaller() && ApplicationRegistry.checkApplicationId(file2 = new File(file, "Contents/Resources/app"))) {
                    return file2;
                }
                GUIHelper.showMessage(Util.getParentWindow(), resourceBundle.getString("NoTargetApplication"), 1);
            }
            return null;
        }
        boolean bl3 = ApplicationRegistry.isUpdateDirectory(file);
        if (!bl3) {
            long l = (long)((double)ContentInstaller.getInstance().getMinSize() * 1.1);
            long l2 = SystemInfo.getFreeDiskSpace(file);
            if (l2 != -1L && l > l2) {
                try {
                    if (InstallerUtil.isUnattended()) {
                        System.err.println("Not enough disk space for target directory: " + file.getAbsolutePath());
                        return null;
                    }
                    int n = GUIHelper.showOptionDialog(Util.getParentWindow(), MessageFormat.format(resourceBundle.getString("DiskSpaceWarning"), String.valueOf(l / 1024L), String.valueOf(l2 / 1024L)), new String[]{resourceBundle.getString("ButtonYes"), resourceBundle.getString("ButtonNo")}, 3);
                    if (n == 1) {
                        return null;
                    }
                }
                catch (UserCanceledException userCanceledException) {
                    return null;
                }
            }
        }
        if (installerConfig.getInstallerType() == 1 && this.existingDirWarning && file.exists() && !bl3 && !this.getContext().isUnattended() && bl) {
            try {
                int n = GUIHelper.showOptionDialog(Util.getParentWindow(), MessageFormat.format(resourceBundle.getString("DirExists"), file.getAbsolutePath()), new String[]{resourceBundle.getString("ButtonYes"), resourceBundle.getString("ButtonNo")}, 3);
                if (n == 1) {
                    return null;
                }
            }
            catch (UserCanceledException userCanceledException) {
                return null;
            }
        }
        return file;
    }

    private File getSelectedDir() {
        this.initDirectorySelector();
        return this.directorySelector.getSelectedFile();
    }
}

