/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.annotation.Table;
import org.exoplatform.services.database.annotation.TableField;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.impl.UserProfileImpl;

@Table(name="EXO_USER_PROFILE", field={@TableField(name="USER_NAME", type="string", length=100, unique=true, nullable=false), @TableField(name="PROFILE", type="string", length=2000)})
public class UserProfileData
extends DBObject {
    private static transient XStream xstream_;
    private String userName;
    private String profile;

    public UserProfileData() {
    }

    public UserProfileData(String userName) {
        StringBuffer b = new StringBuffer();
        b.append("<user-profile>\n").append("  <userName>").append(userName).append("</userName>\n");
        b.append("</user-profile>\n");
        this.userName = userName;
        this.profile = b.toString();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String s) {
        this.userName = s;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String s) {
        this.profile = s;
    }

    public UserProfile getUserProfile() {
        XStream xstream = UserProfileData.getXStream();
        UserProfileImpl up = (UserProfileImpl)xstream.fromXML(this.profile);
        return up;
    }

    public void setUserProfile(UserProfile up) {
        if (up == null) {
            this.profile = "";
        }
        UserProfileImpl impl = (UserProfileImpl)up;
        this.userName = up.getUserName();
        XStream xstream = UserProfileData.getXStream();
        this.profile = xstream.toXML((Object)impl);
    }

    private static XStream getXStream() {
        if (xstream_ == null) {
            xstream_ = new XStream((HierarchicalStreamDriver)new XppDriver());
            xstream_.alias("user-profile", UserProfileImpl.class);
        }
        return xstream_;
    }
}

