/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.realm.jndi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jsecurity.jndi.JndiLocator;
import org.jsecurity.realm.Realm;
import org.jsecurity.realm.RealmFactory;
import org.jsecurity.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiRealmFactory
extends JndiLocator
implements RealmFactory {
    Collection<String> jndiNames = null;

    public Collection<String> getJndiNames() {
        return this.jndiNames;
    }

    public void setJndiNames(Collection<String> jndiNames) {
        this.jndiNames = jndiNames;
    }

    public void setJndiNames(String commaDelimited) throws IllegalStateException {
        String arg = StringUtils.clean(commaDelimited);
        if (arg == null) {
            String msg = "One or more comma-delimited jndi names must be specified for the " + this.getClass().getName() + " to locate Realms.";
            throw new IllegalStateException(msg);
        }
        String[] names = StringUtils.tokenizeToStringArray(arg, ",");
        this.setJndiNames(Arrays.asList(names));
    }

    @Override
    public Collection<Realm> getRealms() throws IllegalStateException {
        Collection<String> jndiNames = this.getJndiNames();
        if (jndiNames == null || jndiNames.isEmpty()) {
            String msg = "One or more jndi names must be specified for the " + this.getClass().getName() + " to locate Realms.";
            throw new IllegalStateException(msg);
        }
        ArrayList<Realm> realms = new ArrayList<Realm>(jndiNames.size());
        for (String name : jndiNames) {
            try {
                Realm realm = (Realm)this.lookup(name, Realm.class);
                realms.add(realm);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to look up realm with jndi name '" + name + "'.", e);
            }
        }
        return realms.isEmpty() ? null : realms;
    }
}

