/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.finish;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class RebootAction
extends SystemInstallOrUninstallAction {
    private boolean askUser = true;

    protected boolean execute(Context context) throws UserCanceledException {
        throw new UnsupportedOperationException("should not be called");
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        this.reboot(installerContext, "FinishedRestartMessage");
        return true;
    }

    public boolean uninstall(UninstallerContext uninstallerContext) throws UserCanceledException {
        this.reboot(uninstallerContext, "UninstalledAndNeedsRestart");
        return true;
    }

    private void reboot(Context context, String string) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            if (context.isUnattended() || !this.askUser) {
                Misc.reboot();
            } else {
                ResourceBundle resourceBundle = Messages.getMessages();
                int n = GUIHelper.showOptionDialog(null, MessageFormat.format(resourceBundle.getString(string), InstallerConfig.getCurrentInstance().getApplicationName()), new String[]{resourceBundle.getString("ButtonYes"), resourceBundle.getString("ButtonNo")}, 3);
                if (n == 0) {
                    Misc.reboot();
                }
            }
        }
    }

    public boolean isAskUser() {
        return this.askUser;
    }

    public void setAskUser(boolean bl) {
        this.askUser = bl;
    }
}

