/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultUrlGenerator
implements UrlGenerator {
    protected static final Pattern ALLOWED_FEATURE_NAME = Pattern.compile("[0-9a-zA-Z_\\.\\-]+");
    protected static final String IFRAME_URI_PARAM = "gadgets.iframeBaseUri";
    protected static final String JS_URI_PARAM = "gadgets.jsUriTemplate";
    protected static final String OAUTH_GADGET_CALLBACK_URI_PARAM = "gadgets.oauthGadgetCallbackTemplate";
    private final String jsChecksum;
    private final Map<String, Uri> iframeBaseUris = Maps.newHashMap();
    private final Map<String, String> jsUriTemplates = Maps.newHashMap();
    private final Map<String, String> oauthCallbackUriTemplates = Maps.newHashMap();
    private final LockedDomainService lockedDomainService;

    @Inject
    public DefaultUrlGenerator(ContainerConfig config, LockedDomainService lockedDomainService, GadgetFeatureRegistry registry) {
        for (String container : config.getContainers()) {
            this.iframeBaseUris.put(container, Uri.parse((String)config.getString(container, IFRAME_URI_PARAM)));
            this.jsUriTemplates.put(container, config.getString(container, JS_URI_PARAM));
            this.oauthCallbackUriTemplates.put(container, config.getString(container, OAUTH_GADGET_CALLBACK_URI_PARAM));
        }
        this.lockedDomainService = lockedDomainService;
        StringBuilder jsBuf = new StringBuilder();
        for (GadgetFeature feature : registry.getAllFeatures()) {
            for (JsLibrary library : feature.getJsLibraries(null, null)) {
                jsBuf.append(library.getContent());
            }
        }
        this.jsChecksum = HashUtil.checksum((byte[])jsBuf.toString().getBytes());
    }

    @Override
    public String getBundledJsUrl(Collection<String> features, GadgetContext context) {
        String jsPrefix = this.jsUriTemplates.get(context.getContainer());
        if (jsPrefix == null) {
            return "";
        }
        return jsPrefix.replace("%host%", context.getHost()).replace("%js%", this.getBundledJsParam(features, context));
    }

    @Override
    public String getBundledJsParam(Collection<String> features, GadgetContext context) {
        StringBuilder buf = new StringBuilder();
        boolean first = false;
        for (String feature : features) {
            if (!ALLOWED_FEATURE_NAME.matcher(feature).matches()) continue;
            if (!first) {
                first = true;
            } else {
                buf.append(':');
            }
            buf.append(feature);
        }
        if (!first) {
            buf.append("core");
        }
        buf.append(".js?v=").append(this.jsChecksum).append("&container=").append(context.getContainer()).append("&debug=").append(context.getDebug() ? "1" : "0");
        return buf.toString();
    }

    @Override
    public String getIframeUrl(Gadget gadget) {
        UriBuilder uri;
        GadgetContext context = gadget.getContext();
        GadgetSpec spec = gadget.getSpec();
        String url = context.getUrl().toString();
        View view = gadget.getCurrentView();
        View.ContentType type = view == null ? View.ContentType.HTML : view.getType();
        switch (type) {
            case URL: {
                uri = new UriBuilder(view.getHref());
                break;
            }
            default: {
                Uri iframeBaseUri = this.iframeBaseUris.get(context.getContainer());
                uri = iframeBaseUri != null ? new UriBuilder(iframeBaseUri) : new UriBuilder();
                String host = this.lockedDomainService.getLockedDomainForGadget(gadget, context.getContainer());
                if (host == null) break;
                uri.setAuthority(host);
            }
        }
        uri.addQueryParameter("container", context.getContainer());
        if (context.getModuleId() != 0) {
            uri.addQueryParameter("mid", Integer.toString(context.getModuleId()));
        }
        if (context.getIgnoreCache()) {
            uri.addQueryParameter("nocache", "1");
        } else {
            uri.addQueryParameter("v", spec.getChecksum());
        }
        uri.addQueryParameter("lang", context.getLocale().getLanguage());
        uri.addQueryParameter("country", context.getLocale().getCountry());
        uri.addQueryParameter("view", context.getView());
        UserPrefs prefs = context.getUserPrefs();
        for (UserPref pref : gadget.getSpec().getUserPrefs()) {
            String name = pref.getName();
            String value = prefs.getPref(name);
            if (value == null) {
                value = pref.getDefaultValue();
            }
            uri.addQueryParameter("up_" + pref.getName(), value);
        }
        if (type != View.ContentType.URL) {
            uri.addQueryParameter("url", url);
        }
        return uri.toString();
    }

    @Override
    public String getGadgetDomainOAuthCallback(String container, String gadgetHost) {
        String callback = this.oauthCallbackUriTemplates.get(container);
        if (callback == null) {
            return null;
        }
        return callback.replace("%host%", gadgetHost);
    }
}

