/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

public class JavascriptKey {
    private final String module;
    private final String scriptPath;
    private final String contextPath;

    public JavascriptKey(String module, String scriptPath, String contextPath) throws IllegalArgumentException {
        if (module == null || scriptPath == null || contextPath == null) {
            throw new IllegalArgumentException("Module and scriptPath are mandatory for JavascriptKey");
        }
        this.module = module;
        this.scriptPath = scriptPath;
        this.contextPath = contextPath;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JavascriptKey) {
            JavascriptKey that = (JavascriptKey)obj;
            return this.module.equals(that.module) && this.scriptPath.equals(that.scriptPath) && this.contextPath.equals(that.contextPath);
        }
        return false;
    }

    public String getModule() {
        return this.module;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isExternalScript() {
        return this.scriptPath.startsWith("http") || this.scriptPath.startsWith("https");
    }
}

