/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import com.sun.mail.util.MailSSLSocketFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoMailTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager;
    public static final String PATH_CERTS_FILE = System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + "security";
    private String pathCertFile;
    private char[] pwdCertFile = null;
    private Map<String, Certificate> temporaryCerts = new HashMap<String, Certificate>();
    private static final Log log = ExoLogger.getLogger((String)"cs.mail.service");
    private KeyStore keystore;
    private String hostname;
    private String protocolName;
    private boolean isStoreCertPermanent = false;
    private File ksfile;

    public ExoMailTrustManager(String relPath, boolean isStorePermanent, String host, String sslProtocol) throws GeneralSecurityException {
        this(relPath, isStorePermanent);
        this.hostname = host;
        if (sslProtocol != null) {
            this.protocolName = sslProtocol;
        }
    }

    public ExoMailTrustManager() throws GeneralSecurityException {
        this(null, true);
    }

    public ExoMailTrustManager(String pathCertFile, boolean storePermanent) throws GeneralSecurityException {
        this.isStoreCertPermanent = storePermanent;
        File temFile = null;
        boolean isLoged = false;
        try {
            if (pathCertFile != null) {
                temFile = new File(pathCertFile);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pathCertFile = pathCertFile == null || temFile == null || !temFile.isDirectory() && !temFile.isFile() ? PATH_CERTS_FILE : pathCertFile;
        if (temFile != null) {
            temFile.delete();
        }
        try {
            this.refreshTrustManager();
        }
        catch (Exception e) {
            if (!isLoged) {
                log.warn((Object)"Cannot refresh trustmanager. The certs that presented by server mail are not stored.\n", (Throwable)e);
            }
            isLoged = true;
        }
        if (isLoged) {
            throw new GeneralSecurityException();
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (this.trustManager == null || !(this.trustManager instanceof X509TrustManager)) {
            return new X509Certificate[0];
        }
        return this.trustManager.getAcceptedIssuers();
    }

    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        if (this.trustManager != null) {
            try {
                this.trustManager.checkServerTrusted(certs, authType);
            }
            catch (CertificateException ce) {
                this.updateCerts(certs, this.isStoreCertPermanent);
                this.trustManager.checkServerTrusted(certs, authType);
            }
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.trustManager != null) {
            this.trustManager.checkClientTrusted(chain, authType);
        }
    }

    protected void refreshTrustManager() throws Exception {
        KeyStore ks = this.getKeyStore(this.pathCertFile, null);
        Set<String> aliases = this.temporaryCerts.keySet();
        if (aliases != null && aliases.size() > 0) {
            for (String alias : aliases) {
                ks.setCertificateEntry(alias, this.temporaryCerts.get(alias));
            }
        }
        this.keystore = ks;
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        TrustManager[] tms = tmf.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)tms[i];
            return;
        }
        throw new NoSuchAlgorithmException("There is no X059TrustManager in TrustManager");
    }

    protected void updateCerts(Certificate[] certs, boolean isStoreCertPermanent) {
        String alias = this.hostname;
        try {
            FileOutputStream fos = null;
            X509Certificate x509 = (X509Certificate)certs[0];
            if (Utils.isEmptyField(alias)) {
                alias = ((Object)x509.getSubjectDN()).toString().split(",")[0].split("=")[1];
            }
            if (Utils.isEmptyField(alias)) {
                alias = x509.getSubjectX500Principal().toString().split(",")[0].split("=")[1];
            }
            if (Utils.isEmptyField(alias)) {
                alias = UUID.randomUUID().toString();
            }
            if (isStoreCertPermanent) {
                this.keystore.setCertificateEntry(alias, x509);
                try {
                    fos = this.ksfile != null ? new FileOutputStream(this.ksfile) : new FileOutputStream(ExoMailTrustManager.getCertFile(this.pathCertFile));
                    this.keystore.store(fos, this.pwdCertFile);
                    fos.close();
                }
                catch (Exception e) {
                    File certtem = new File("certtem.cer");
                    FileOutputStream os = new FileOutputStream(certtem);
                    ((OutputStream)os).write(x509.toString().getBytes());
                    String command = "keytool -import -alias " + alias + " -trustcacerts -file " + certtem.getPath();
                    Runtime.getRuntime().exec(command);
                    if (certtem != null) {
                        certtem.delete();
                    }
                    ((OutputStream)os).close();
                }
            } else {
                this.temporaryCerts.put(alias, certs[0]);
            }
            this.refreshTrustManager();
        }
        catch (Exception e) {
            log.warn((Object)("The cert of " + alias + " is not updated"));
        }
    }

    public static File getCertFile(String relPath) throws Exception {
        File suncert = new File(relPath);
        if (suncert != null && suncert.isDirectory() && (suncert = new File(relPath, "jssecacerts")) != null && !suncert.isFile()) {
            suncert = new File(relPath, "cacerts");
        }
        if (!suncert.canWrite()) {
            suncert.setWritable(true);
        }
        return suncert;
    }

    protected KeyStore getKeyStore(String relPath, char[] password) throws Exception {
        File certfile;
        this.ksfile = certfile = ExoMailTrustManager.getCertFile(relPath);
        FileInputStream is = new FileInputStream(certfile);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(is, password);
        ((InputStream)is).close();
        return keyStore;
    }

    public ExoMailTrustManager getExomailTrustManager() {
        return (ExoMailTrustManager)this.trustManager;
    }

    public MailSSLSocketFactory trustHosts() throws Exception {
        MailSSLSocketFactory sslsocket = new MailSSLSocketFactory();
        if (this.protocolName != null && !this.protocolName.equalsIgnoreCase("TLS")) {
            sslsocket = new MailSSLSocketFactory(this.protocolName);
        }
        if (this.hostname != null && this.hostname.equalsIgnoreCase("")) {
            sslsocket.setTrustedHosts(new String[]{this.hostname});
        } else {
            sslsocket.setTrustAllHosts(true);
        }
        sslsocket.setTrustManagers(new TrustManager[]{this.trustManager});
        return sslsocket;
    }

    protected void setProtocolName(String protocolname) {
        this.protocolName = protocolname;
    }

    protected void setHostName(String hn) {
        this.hostname = hn;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }
}

