/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.presentation;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.presentation.NodePresentation;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.voting.VotingService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIBaseNodePresentation
extends UIContainer
implements NodePresentation {
    private String language_;
    private boolean enableVote;
    private boolean enableComment;
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIBaseNodePresentation");
    public static final String INPUT_TEXT_AREA = "TEXTAREA".intern();
    public static final String INPUT_WYSIWYG = "WYSIWYG".intern();
    public static final String INPUT_TEXT = "TEXT".intern();

    @Override
    public abstract Node getNode() throws Exception;

    @Override
    public abstract String getTemplatePath() throws Exception;

    @Override
    public abstract Node getOriginalNode() throws Exception;

    public abstract String getRepositoryName() throws Exception;

    @Override
    public String encodeHTML(String text) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.encodeHTML(text);
    }

    @Override
    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        NodeIterator childrenIterator = this.getNode().getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List<String> listCanCreateNodeType = org.exoplatform.ecm.webui.utils.Utils.getListAllowedFileType(this.getNode(), this.getRepository(), templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            attachments.add(childNode);
        }
        return attachments;
    }

    @Override
    public String getAttachmentURL(Node attNode, Parameter[] params) throws Exception {
        return "";
    }

    @Override
    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.getNode(), this.getLanguage());
    }

    @Override
    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> object = loader.loadClass(className);
            service = this.getApplicationComponent(object);
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"Unexpected error", (Throwable)ex);
        }
        return service;
    }

    @Override
    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
            return null;
        }
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    @Override
    public String getIcons(Node node, String size) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon(node, size);
    }

    @Override
    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    @Override
    public String getLanguage() {
        return this.language_;
    }

    @Override
    public void setLanguage(String language) {
        this.language_ = language;
    }

    @Override
    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    @Override
    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.getNode().hasProperty("exo:relation")) {
            Value[] vals = this.getNode().getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    @Override
    public String getRepository() throws Exception {
        return ((ManageableRepository)this.getNode().getSession().getRepository()).getConfiguration().getName();
    }

    @Override
    public String getRssLink() {
        return null;
    }

    @Override
    public boolean isRssLink() {
        return false;
    }

    @Override
    public List getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.getNode());
    }

    @Override
    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName);
    }

    @Override
    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    @Override
    public String getWorkspaceName() throws Exception {
        return this.getNode().getSession().getWorkspace().getName();
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.getRepositoryName());
        String[] workspaces = manageRepo.getWorkspaceNames();
        SessionProvider provider = SessionProviderFactory.createSystemProvider();
        for (String ws : workspaces) {
            try {
                return provider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public List<Node> getCategories(Node node) throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        return taxonomyService.getCategories(node, this.getRepositoryName());
    }

    public List<Node> getTags(Node node) throws Exception {
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        return folksonomyService.getLinkedTagsOfDocumentByScope(1, this.getStrValue("Private", node), node, this.getRepositoryName(), this.getWorkspaceName());
    }

    public long getVotingRate(Node node) throws Exception {
        VotingService votingService = (VotingService)this.getApplicationComponent(VotingService.class);
        return votingService.getVoteTotal(node);
    }

    public String getImageURIInProperty(Node node, String propertyName) throws Exception {
        try {
            InputStream input = node.getProperty(propertyName).getStream();
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
            dresource.setDownloadName(node.getName());
            DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPortletPreferenceValue(String preferenceName) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (requestContext instanceof PortletRequestContext) {
            PortletRequestContext context = (PortletRequestContext)PortletRequestContext.class.cast(requestContext);
            return context.getRequest().getPreferences().getValue(preferenceName, null);
        }
        return null;
    }

    public String[] getPortletPreferenceValues(String preferenceName) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (requestContext instanceof PortletRequestContext) {
            PortletRequestContext context = (PortletRequestContext)PortletRequestContext.class.cast(requestContext);
            return context.getRequest().getPreferences().getValues(preferenceName, null);
        }
        return null;
    }

    @Override
    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage());
    }

    private String getStrValue(String scope, Node node) throws Exception {
        StringBuilder ret = new StringBuilder();
        if ("Private".equals(scope)) {
            ret.append(node.getSession().getUserID());
        } else if ("Group".equals(scope)) {
            for (String group : org.exoplatform.ecm.webui.utils.Utils.getGroups()) {
                ret.append(group).append(';');
            }
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    @Override
    public boolean isEnableComment() {
        return this.enableComment;
    }

    @Override
    public boolean isEnableVote() {
        return this.enableVote;
    }

    @Override
    public void setEnableComment(boolean value) {
        this.enableComment = value;
    }

    @Override
    public void setEnableVote(boolean value) {
        this.enableVote = value;
    }

    public static String getInlineEditingField(String currentValue, String inputType, String propertyName, String cssClass, Node orgNode) throws Exception {
        String portletRealID = Utils.getRealPortletId((PortletRequestContext)WebuiRequestContext.getCurrentInstance());
        ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
        StringBuffer sb = new StringBuffer();
        StringBuffer actionsb = new StringBuffer();
        String repo = ((ManageableRepository)orgNode.getSession().getRepository()).getConfiguration().getName();
        String workspace = orgNode.getSession().getWorkspace().getName();
        String uuid = orgNode.getUUID();
        String strSuggestion = "";
        portletRealID = portletRealID.replace('-', '_');
        String showBlockId = "Current" + cssClass + "_" + portletRealID;
        String editBlockEditorID = "Edit" + cssClass + "_" + portletRealID;
        String editFormID = "Edit" + cssClass + "Form_" + portletRealID;
        String newValueInputId = "new" + cssClass + "_" + portletRealID;
        String currentValueID = "old" + cssClass + "_" + portletRealID;
        String siteName = Util.getPortalRequestContext().getPortalOwner();
        try {
            strSuggestion = resourceBundle.getString("UIPresentation.label.EditingSuggestion");
        }
        catch (Exception E) {
            // empty catch block
        }
        actionsb.append(" return InlineEditor.presentationRequestChange").append(cssClass).append("('").append(currentValueID).append("', '").append(newValueInputId).append("', '").append(repo).append("', '").append(workspace).append("', '").append(uuid).append("', '").append(editBlockEditorID).append("', '").append(showBlockId).append("', '").append(siteName);
        if (inputType.equals(INPUT_WYSIWYG)) {
            actionsb.append("', 1);");
        } else {
            actionsb.append("');");
        }
        String strAction = actionsb.toString();
        sb.append("\n<div id=\"").append(showBlockId).append("\" Class=\"").append(cssClass).append("\"");
        sb.append("title=\"").append(strSuggestion).append("\"");
        sb.append(" onDblClick=\"InlineEditor.presentationSwitchBlock('").append(showBlockId).append("', '").append(editBlockEditorID).append("');\"");
        sb.append("onmouseout=\"this.className='").append(cssClass).append("';\" onmouseover=\"this.className='").append(cssClass).append("Hover';\">").append(currentValue).append("</div>\n");
        sb.append("\t<div id=\"").append(editBlockEditorID).append("\" class=\"Edit").append(cssClass).append(" ClearFix\">\n");
        sb.append("\t\t<form name=\"").append(editFormID).append("\" id=\"").append(editFormID).append("\" onSubmit=\"").append(strAction).append("\">\n");
        sb.append("<DIV style=\"display:none; visible:hidden\" id=\"").append(currentValueID).append("\" name=\"").append(currentValueID).append("\">").append(currentValue).append("</DIV>");
        sb.append("\t\t<a href=\"#\" class =\"CancelButton\" ").append("onClick=\"InlineEditor.presentationSwitchBlock('");
        sb.append(editBlockEditorID).append("', '").append(showBlockId).append("');\">&nbsp;</a>\n");
        sb.append("\t\t<a href=\"#\" class =\"AcceptButton\" onclick=\"").append(strAction).append("\">&nbsp;</a>\n");
        sb.append("\t\t<div class=\"Edit").append(cssClass).append("Input\">\n");
        if (inputType.equals(INPUT_WYSIWYG)) {
            sb.append(UIBaseNodePresentation.createCKEditorField(newValueInputId, "'98%'", "200", currentValue));
        } else if (inputType.equals(INPUT_TEXT_AREA)) {
            sb.append("\t\t<TEXTAREA ").append("\" name =\"");
            sb.append(newValueInputId).append("\" id =\"").append(newValueInputId).append("\" >");
            sb.append(currentValue).append("</TEXTAREA>");
        } else if (inputType.equals(INPUT_TEXT)) {
            sb.append("\t\t<input type=\"").append(inputType).append("\" name =\"");
            sb.append(newValueInputId).append("\" id =\"").append(newValueInputId).append("\" value=\"").append(currentValue).append("\"/>");
        }
        sb.append("\n\t\t</div>\n\t</form>\n</div>");
        return sb.toString();
    }

    private static String createCKEditorField(String name, String width, String height, String value_) {
        String toolbar = "Basic";
        if (width == null) {
            width = "'100%'";
        }
        if (height == null) {
            height = "200";
        }
        StringBuffer contentsCss = new StringBuffer();
        contentsCss.append("[");
        SkinService skinService = (SkinService)WCMCoreUtils.getService(SkinService.class);
        String skin = Util.getUIPortalApplication().getUserPortalConfig().getPortalConfig().getSkin();
        String portal = Util.getUIPortal().getName();
        Collection portalSkins = skinService.getPortalSkins(skin);
        SkinConfig customSkin = skinService.getSkin(portal, Util.getUIPortalApplication().getUserPortalConfig().getPortalConfig().getSkin());
        if (customSkin != null) {
            portalSkins.add(customSkin);
        }
        for (SkinConfig portalSkin : portalSkins) {
            contentsCss.append("'").append(portalSkin.createURL()).append("',");
        }
        contentsCss.delete(contentsCss.length() - 1, contentsCss.length());
        contentsCss.append("]");
        StringBuffer buffer = new StringBuffer();
        if (value_ != null) {
            buffer.append("<textarea id='" + name + "' name='" + name + "'>" + value_ + "</textarea>\n");
        } else {
            buffer.append("<textarea id='" + name + "' name='" + name + "'></textarea>\n");
        }
        buffer.append("<script type='text/javascript'>\n");
        buffer.append("  //<![CDATA[\n");
        buffer.append("    var instances = CKEDITOR.instances['" + name + "']; if (instances) instances.destroy(true);\n");
        buffer.append("    CKEDITOR.replace('" + name + "', {toolbar:'" + toolbar + "', width:" + width + ", height:" + height + ", contentsCss:" + contentsCss + ", ignoreEmptyParagraph:true});\n");
        buffer.append("  //]]>\n");
        buffer.append("</script>\n");
        return buffer.toString();
    }
}

