/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.application.StandaloneAppRequestContext;
import org.exoplatform.portal.application.StandaloneApplication;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.application.Application;

public class StandaloneAppRequestHandler
extends PortalRequestHandler {
    private String webuiConfigPath;
    private String[] PATHS = new String[]{"/standalone"};

    public StandaloneAppRequestHandler(InitParams params) {
        ValueParam valueParam = params.getValueParam("webui.configuration");
        if (valueParam != null) {
            this.webuiConfigPath = valueParam.getValue();
        }
    }

    public String[] getPath() {
        return this.PATHS;
    }

    public void onInit(WebAppController controller, ServletConfig sConfig) throws Exception {
        StandaloneApplication standaloneApplication = new StandaloneApplication(sConfig);
        standaloneApplication.setWebUIConfigPath(this.webuiConfigPath);
        standaloneApplication.onInit();
        controller.addApplication((Application)standaloneApplication);
    }

    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        log.debug((Object)("Session ID = " + req.getSession().getId()));
        res.setHeader("Cache-Control", "no-cache");
        StandaloneApplication app = (StandaloneApplication)controller.getApplication("StandaloneApplication");
        StandaloneAppRequestContext context = new StandaloneAppRequestContext(app, req, res);
        this.processRequest(context, app);
    }
}

