/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionResponse;
import javax.xml.namespace.QName;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.commons.utils.PageListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.page.PageQueryAccessList;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageFactory;
import org.exoplatform.portal.webui.page.UIPageForm;
import org.exoplatform.portal.webui.page.UIPageTemplateOptions;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.config.annotation.ParamConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRepeater;
import org.exoplatform.webui.core.UISearch;
import org.exoplatform.webui.core.UIVirtualList;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputItemSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UISearchForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageBrowser.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIPageBrowse.deletePage"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={AddNewActionListener.class})}), @ComponentConfig(id="UIBrowserPageForm", type=UIPageForm.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SavePageActionListener.class}, name="Save"), @EventConfig(listeners={UIPageForm.ChangeOwnerTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageForm.ChangeOwnerIdActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageForm.SelectMembershipActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}, initParams={@ParamConfig(name="PageTemplate", value="system:/WEB-INF/conf/uiconf/portal/webui/page/PageTemplate.groovy")}), @ComponentConfig(type=UIFormInputSet.class, id="PermissionSetting", template="system:/groovy/webui/core/UITabSelector.gtmpl", events={@EventConfig(listeners={UIFormInputSet.SelectComponentActionListener.class})})})
@Serialized
public class UIPageBrowser
extends UISearch {
    public static final String[] BEAN_FIELD = new String[]{"pageId", "title", "accessPermissions", "editPermission"};
    public static final String[] ACTIONS = new String[]{"EditInfo", "Delete"};
    private boolean showAddNewPage = false;
    protected String pageSelectedId_;
    private static List<SelectItemOption<String>> OPTIONS = new ArrayList<SelectItemOption<String>>(3);
    private Query<Page> lastQuery_;

    public UIPageBrowser() throws Exception {
        super(OPTIONS);
        ((UISearchForm)this.getChild(UISearchForm.class)).setId("UIPageSearch");
        UIRepeater uiRepeater = (UIRepeater)this.createUIComponent(UIRepeater.class, null, null);
        uiRepeater.configure("pageId", BEAN_FIELD, ACTIONS);
        UIVirtualList virtualList = (UIVirtualList)this.addChild(UIVirtualList.class, null, null);
        virtualList.setPageSize(10);
        virtualList.setUIComponent((UIComponent)uiRepeater);
    }

    public Query<Page> getLastQuery() {
        return this.lastQuery_;
    }

    public boolean feedDataWithQuery(Query<Page> query) throws Exception {
        this.lastQuery_ = query;
        UIVirtualList virtualList = (UIVirtualList)this.getChild(UIVirtualList.class);
        if (this.lastQuery_ == null) {
            this.lastQuery_ = new Query(null, null, null, null, Page.class);
        }
        virtualList.dataBind((PageList)new PageQueryAccessList(this.lastQuery_, 10));
        UIRepeater repeater = (UIRepeater)virtualList.getDataFeed();
        PageList datasource = repeater.getDataSource();
        return datasource.getAvailable() > 0;
    }

    public static void showNoResultMessagePopup() {
        UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
        uiApp.addMessage(new ApplicationMessage("UISearchForm.msg.empty", null));
        Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
    }

    public void quickSearch(UIFormInputSet quickSearchInput) throws Exception {
        UIFormStringInput input = (UIFormStringInput)quickSearchInput.getChild(0);
        UIFormSelectBox select = (UIFormSelectBox)quickSearchInput.getChild(1);
        String value = (String)input.getValue();
        String selectBoxValue = (String)select.getValue();
        Query query = new Query(null, null, null, null, Page.class);
        if (selectBoxValue.equals("title")) {
            query.setTitle(value);
        } else if (selectBoxValue.equals("ownerType")) {
            query.setOwnerType(value);
        } else if (selectBoxValue.equals("ownerId")) {
            query.setOwnerId(value);
        }
        query.setName(null);
        this.lastQuery_ = query;
        boolean dataAvailable = this.feedDataWithQuery(this.lastQuery_);
        if (!dataAvailable) {
            UIPageBrowser.showNoResultMessagePopup();
        }
        if (this.getParent() instanceof UIPopupWindow) {
            UIPopupWindow popupWindow = (UIPopupWindow)this.getParent();
            popupWindow.setShow(true);
        }
    }

    public boolean isShowAddNewPage() {
        return this.showAddNewPage;
    }

    public void setShowAddNewPage(boolean showAddNewPage) {
        this.showAddNewPage = showAddNewPage;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = null;
        action = uiForm != null ? uiForm.getSubmitAction() : context.getRequestParameter("formOp");
        if (action == null) {
            return;
        }
        Event event = this.createEvent(action, Event.Phase.PROCESS, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public void advancedSearch(UIFormInputSet advancedSearchInput) throws Exception {
    }

    static {
        WebuiRequestContext contextui = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = contextui.getApplicationResourceBundle();
        OPTIONS.add((SelectItemOption<String>)new SelectItemOption(res.getString("UIPageSearch.label.option.ownerType"), (Object)"ownerType"));
        OPTIONS.add((SelectItemOption<String>)new SelectItemOption(res.getString("UIPageSearch.label.option.ownerId"), (Object)"ownerId"));
        OPTIONS.add((SelectItemOption<String>)new SelectItemOption(res.getString("UIPageSearch.label.option.title"), (Object)"title"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SavePageActionListener
    extends UIPageForm.SaveActionListener {
        @Override
        public void execute(Event<UIPageForm> event) throws Exception {
            UIPageForm uiPageForm = (UIPageForm)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageForm.getAncestorOfType(UIPortalApplication.class);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPage uiPage = uiPageForm.getUIPage();
            Page page = new Page();
            uiPageForm.invokeSetBindingBean(page);
            DataStorage dataService = (DataStorage)uiPageForm.getApplicationComponent(DataStorage.class);
            if (uiPage == null) {
                Page existPage = dataService.getPage(page.getPageId());
                if (existPage != null) {
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageForm.msg.sameName", null));
                    pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                    return;
                }
                page.setModifiable(true);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                dataService.create(page);
                this.postSave(uiPortalApp, pcontext);
                return;
            }
            page.setOwnerType(uiPage.getOwnerType());
            List uiChildren = uiPage.getChildren();
            if (uiChildren == null) {
                return;
            }
            ArrayList<ModelObject> children = new ArrayList<ModelObject>();
            for (UIComponent child : uiChildren) {
                ModelObject component = PortalDataMapper.buildModelObject(child);
                if (component == null) continue;
                children.add(component);
            }
            page.setChildren(children);
            uiPage.getChildren().clear();
            PortalDataMapper.toUIPage(uiPage, page);
        }

        private void postSave(UIPortalApplication uiPortalApp, WebuiRequestContext context) throws Exception {
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            uiMaskWS.setShow(false);
            context.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            UIWorkingWorkspace uiWorkWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            uiWorkWS.updatePortletsByName("PageManagementPortlet");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNewActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiApp = (UIPortalApplication)prContext.getUIApplication();
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPageForm uiPageForm = uiMaskWS.createUIComponent(UIPageForm.class, "UIBrowserPageForm", "UIPageForm");
            uiMaskWS.setUIComponent((UIComponent)uiPageForm);
            uiMaskWS.setShow(true);
            uiPageForm.getUIStringInput("ownerType").setValue((Object)"user");
            uiPageForm.getUIStringInput("ownerId").setValue((Object)prContext.getRemoteUser());
            uiPageForm.removeChildById("PermissionSetting");
            uiPageForm.removeChild(UIFormInputItemSelector.class);
            UIPageTemplateOptions uiTemplateConfig = (UIPageTemplateOptions)uiPageForm.createUIComponent(UIPageTemplateOptions.class, null, null);
            uiPageForm.addUIFormInput((UIFormInput)uiTemplateConfig);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInfoActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            String pageID = context.getRequestParameter("objectId");
            DataStorage service = (DataStorage)uiPageBrowser.getApplicationComponent(DataStorage.class);
            Page page = service.getPage(pageID);
            if (page == null) {
                context.getUIApplication().addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", (Object[])new String[]{pageID}, 1));
                return;
            }
            UIPageFactory clazz = UIPageFactory.getInstance(page.getFactoryId());
            UIPage uipage = clazz.createUIPage(null);
            uipage.switchToEditMode(page);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIPageBrowser> {
        public void execute(Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            String id = pcontext.getRequestParameter("objectId");
            UserPortalConfigService service = (UserPortalConfigService)uiPageBrowser.getApplicationComponent(UserPortalConfigService.class);
            DataStorage dataService = (DataStorage)uiPageBrowser.getApplicationComponent(DataStorage.class);
            UIPortalApplication uiPortalApp = (UIPortalApplication)pcontext.getUIApplication();
            if (service.getPage(id) == null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.PageNotExist", (Object[])new String[]{id}, 1));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            Page page = service.getPage(id, pcontext.getRemoteUser());
            if (page == null || !page.isModifiable() || page.getOwnerType().equals("user") && !page.getOwnerId().equals(pcontext.getRemoteUser())) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.delete.NotDelete", (Object[])new String[]{id}, 1));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            UIPortal uiPortal = Util.getUIPortal();
            boolean isDeleteCurrentPage = uiPortal.getSelectedNode().getPageReference().equals(page.getPageId());
            if (isDeleteCurrentPage && page.getOwnerType().equals("user")) {
                ApplicationMessage msg = new ApplicationMessage("UIPageBrowser.msg.delete.DeleteCurrentUserPage", null, 1);
                event.getRequestContext().getUIApplication().addMessage(msg);
                return;
            }
            UIVirtualList virtualList = (UIVirtualList)uiPageBrowser.getChild(UIVirtualList.class);
            UIRepeater repeater = (UIRepeater)virtualList.getDataFeed();
            PageListAccess datasource = (PageListAccess)repeater.getDataSource();
            int currentPage = datasource.getCurrentPage();
            dataService.remove(page);
            if (isDeleteCurrentPage) {
                PageNodeEvent<UIPortal> pnevent = new PageNodeEvent<UIPortal>(uiPortal, "ChangePageNode", uiPortal.getSelectedNode().getUri());
                uiPortal.broadcast(pnevent, Event.Phase.PROCESS);
            } else {
                boolean dataAvailable = uiPageBrowser.feedDataWithQuery(uiPageBrowser.getLastQuery());
                if (!dataAvailable) {
                    UIPageBrowser.showNoResultMessagePopup();
                }
                if (currentPage > datasource.getAvailablePage()) {
                    currentPage = datasource.getAvailablePage();
                }
                datasource.getPage(currentPage);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPageBrowser);
            }
            if (page.getOwnerType().equals("user")) {
                this.removePageNode(page, event);
            }
        }

        private void removePageNode(Page page, Event<UIPageBrowser> event) throws Exception {
            UIPageBrowser uiPageBrowser = (UIPageBrowser)((Object)event.getSource());
            DataStorage dataService = (DataStorage)uiPageBrowser.getApplicationComponent(DataStorage.class);
            PageNavigation pageNavigation = null;
            UIPortalApplication portalApplication = Util.getUIPortalApplication();
            List<PageNavigation> listPageNavigation = portalApplication.getNavigations();
            for (PageNavigation pageNvg : listPageNavigation) {
                if (!pageNvg.getOwnerType().equals("user")) continue;
                pageNavigation = pageNvg;
                break;
            }
            UIPortal uiPortal = Util.getUIPortal();
            PageNode tobeRemoved = null;
            ArrayList nodes = pageNavigation.getNodes();
            for (PageNode pageNode : nodes) {
                String pageReference = pageNode.getPageReference();
                String pageId = page.getPageId();
                if (pageReference == null || !pageReference.equals(pageId)) continue;
                tobeRemoved = pageNode;
                break;
            }
            if (tobeRemoved != null) {
                pageNavigation.getNodes().remove(tobeRemoved);
                String pageRef = tobeRemoved.getPageReference();
                if (pageRef != null && pageRef.length() > 0) {
                    uiPortal.clearUIPage(pageRef);
                }
                dataService.save(pageNavigation);
                ActionResponse actResponse = (ActionResponse)event.getRequestContext().getResponse();
                actResponse.setEvent(new QName("NavigationChange"), (Serializable)((Object)tobeRemoved.getName()));
            }
        }
    }
}

