/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemDefinitionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PropertyDefinitionImpl
extends ItemDefinitionImpl
implements PropertyDefinition {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.PropertyDefinitionImpl");
    private final PropertyDefinitionData propertyDefinitionData;

    public PropertyDefinitionImpl(PropertyDefinitionData propertyDefinitionData, NodeTypeDataManager nodeTypeDataManager, ExtendedNodeTypeManager nodeTypeManager, LocationFactory locationFactory, ValueFactory valueFactory, ItemDataConsumer dataManager) {
        super(propertyDefinitionData, nodeTypeDataManager, nodeTypeManager, locationFactory, valueFactory, dataManager);
        this.propertyDefinitionData = propertyDefinitionData;
    }

    public Value[] getDefaultValues() {
        String[] defaultValues = this.propertyDefinitionData.getDefaultValues();
        if (defaultValues == null) {
            return null;
        }
        Value[] vals = new Value[defaultValues.length];
        for (int i = 0; i < defaultValues.length; ++i) {
            if (this.propertyDefinitionData.getRequiredType() == 0) {
                vals[i] = this.valueFactory.createValue(defaultValues[i]);
                continue;
            }
            try {
                vals[i] = this.valueFactory.createValue(defaultValues[i], this.propertyDefinitionData.getRequiredType());
                continue;
            }
            catch (ValueFormatException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return vals;
    }

    public int getRequiredType() {
        return this.propertyDefinitionData.getRequiredType();
    }

    public String[] getValueConstraints() {
        return this.propertyDefinitionData.getValueConstraints();
    }

    public boolean isMultiple() {
        return this.propertyDefinitionData.isMultiple();
    }
}

