/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jcr.InvalidItemStateException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class HSQLDBMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    protected int addNodeRecord(final NodeData data) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.addNodeRecord(data);
            }
        });
    }

    protected int addPropertyRecord(final PropertyData data) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.addPropertyRecord(data);
            }
        });
    }

    protected int addReference(final PropertyData data) throws SQLException, IOException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.addReference(data);
            }
        });
    }

    protected int addValueData(final String cid, final int orderNumber, final InputStream stream, final int streamLength, final String storageDesc) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.addValueData(cid, orderNumber, stream, streamLength, storageDesc);
            }
        });
    }

    protected int deleteItemByIdentifier(final String identifier) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.deleteItemByIdentifier(identifier);
            }
        });
    }

    protected int deleteReference(final String propertyIdentifier) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.deleteReference(propertyIdentifier);
            }
        });
    }

    protected int deleteValueData(final String cid) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.deleteValueData(cid);
            }
        });
    }

    protected ResultSet findChildNodesByParentIdentifier(final String parentIdentifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findChildNodesByParentIdentifier(parentIdentifier);
            }
        });
    }

    protected ResultSet findChildNodesByParentIdentifierCQ(final String parentIdentifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findChildNodesByParentIdentifierCQ(parentIdentifier);
            }
        });
    }

    protected ResultSet findChildNodesCountByParentIdentifier(final String parentIdentifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findChildNodesCountByParentIdentifier(parentIdentifier);
            }
        });
    }

    protected ResultSet findChildPropertiesByParentIdentifier(final String parentIdentifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findChildPropertiesByParentIdentifier(parentIdentifier);
            }
        });
    }

    protected ResultSet findChildPropertiesByParentIdentifierCQ(final String parentIdentifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findChildPropertiesByParentIdentifierCQ(parentIdentifier);
            }
        });
    }

    protected ResultSet findItemByIdentifier(final String identifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findItemByIdentifier(identifier);
            }
        });
    }

    protected ResultSet findItemByName(final String parentId, final String name, final int index) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findItemByName(parentId, name, index);
            }
        });
    }

    protected ResultSet findItemQPathByIdentifierCQ(final String identifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findItemQPathByIdentifierCQ(identifier);
            }
        });
    }

    protected ResultSet findNodeMainPropertiesByParentIdentifierCQ(final String parentIdentifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findNodeMainPropertiesByParentIdentifierCQ(parentIdentifier);
            }
        });
    }

    protected ResultSet findPropertyByName(final String parentId, final String name) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findPropertyByName(parentId, name);
            }
        });
    }

    protected ResultSet findReferences(final String nodeIdentifier) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findReferences(nodeIdentifier);
            }
        });
    }

    protected ResultSet findValueByPropertyIdOrderNumber(final String cid, final int orderNumb) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findValueByPropertyIdOrderNumber(cid, orderNumb);
            }
        });
    }

    protected ResultSet findValuesByPropertyId(final String cid) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findValuesByPropertyId(cid);
            }
        });
    }

    protected ResultSet findValuesStorageDescriptorsByPropertyId(final String cid) throws SQLException {
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.findValuesStorageDescriptorsByPropertyId(cid);
            }
        });
    }

    protected int renameNode(final NodeData data) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.renameNode(data);
            }
        });
    }

    protected int updateNodeByIdentifier(final int version, final int index, final int orderNumb, final String identifier) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.updateNodeByIdentifier(version, index, orderNumb, identifier);
            }
        });
    }

    protected int updatePropertyByIdentifier(final int version, final int type, final String identifier) throws SQLException {
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBMultiDbJDBCConnection.super.updatePropertyByIdentifier(version, type, identifier);
            }
        });
    }

    public HSQLDBMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from JCR_MITEM I, JCR_MVALUE V where I.PARENT_ID=? and I.I_CLASS=2 and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_NODES_BY_PARENTID = "select * from JCR_MITEM where PARENT_ID=? and I_CLASS=1 order by N_ORDER_NUM";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from JCR_MITEM where PARENT_ID=? and I_CLASS=1";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from JCR_MITEM where PARENT_ID=? and I_CLASS=2 order by ID";
        this.FIND_NODES_BY_PARENTID_CQ = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_MITEM I, JCR_MITEM P, JCR_MVALUE V where I.PARENT_ID=? and I.I_CLASS=1 and (P.PARENT_ID=I.ID and P.I_CLASS=2 and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID) order by I.N_ORDER_NUM, I.ID";
        this.FIND_PROPERTIES_BY_PARENTID_CQ = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_MITEM I LEFT OUTER JOIN JCR_MVALUE V ON (V.PROPERTY_ID=I.ID) where I.PARENT_ID=? and I.I_CLASS=2 order by I.NAME";
    }

    protected QPath traverseQPath(String cpid) throws SQLException, InvalidItemStateException, IllegalNameException {
        return this.traverseQPathSQ(cpid);
    }
}

