/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.IOException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileOperation;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class DeleteValues
extends ValueFileOperation {
    private final File[] files;
    private ValueFileOperation.ValueFileLock[] locks;

    public DeleteValues(File[] files, ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir) {
        super(resources, cleaner, tempDir);
        this.files = files;
    }

    public void execute() throws IOException {
        this.makePerformed();
        this.locks = new ValueFileOperation.ValueFileLock[this.files.length];
        for (int i = 0; i < this.files.length; ++i) {
            ValueFileOperation.ValueFileLock fl = new ValueFileOperation.ValueFileLock(this, this.files[i]);
            fl.lock();
            this.locks[i] = fl;
        }
    }

    public void rollback() throws IOException {
        if (this.locks != null) {
            for (ValueFileOperation.ValueFileLock fl : this.locks) {
                fl.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        block7: {
            if (this.locks != null) {
                try {
                    for (File f : this.files) {
                        if (PrivilegedFileHelper.delete((File)f)) continue;
                        this.cleaner.addFile(f);
                    }
                    Object var6_5 = null;
                    if (this.locks == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (this.locks != null) {
                        for (ValueFileOperation.ValueFileLock fl : this.locks) {
                            fl.unlock();
                        }
                    }
                    throw throwable;
                }
                for (ValueFileOperation.ValueFileLock fl : this.locks) {
                    fl.unlock();
                }
            }
        }
    }
}

