/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.commons.utils.CharEncoder;
import org.exoplatform.commons.utils.CharsetCharEncoder;
import org.exoplatform.commons.utils.CharsetTextEncoder;
import org.exoplatform.commons.utils.TableCharEncoder;
import org.exoplatform.commons.utils.TextEncoder;

public class CachedStylesheet {
    private static final TextEncoder encoder = new CharsetTextEncoder((CharEncoder)new TableCharEncoder(CharsetCharEncoder.getUTF8()));
    private final String text;
    private final byte[] bytes;
    private long lastModified;

    public CachedStylesheet(String text) {
        byte[] bytes;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(text.length() * 2);
            encoder.encode(text, 0, text.length(), (OutputStream)baos);
            baos.flush();
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e, "That should not happen");
        }
        this.text = text;
        this.bytes = bytes;
        this.lastModified = new Date().getTime() / 1000L * 1000L;
    }

    public String getText() {
        return this.text;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void writeTo(BinaryOutput output) throws IOException {
        output.write(this.bytes);
    }
}

