/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.hibernate.AssertionFailure;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.QueryParameters;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.ParameterContainer;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.util.SyntheticAndFactory;
import org.hibernate.impl.FilterImpl;
import org.hibernate.param.DynamicFilterParameterSpecification;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinProcessor
implements SqlTokenTypes {
    private static final Logger log = LoggerFactory.getLogger((Class)JoinProcessor.class);
    private final HqlSqlWalker walker;
    private final SyntheticAndFactory syntheticAndFactory;
    static /* synthetic */ Class class$java$util$Collection;

    public JoinProcessor(HqlSqlWalker walker) {
        this.walker = walker;
        this.syntheticAndFactory = new SyntheticAndFactory(walker);
    }

    public static int toHibernateJoinType(int astJoinType) {
        switch (astJoinType) {
            case 132: {
                return 1;
            }
            case 28: {
                return 0;
            }
            case 133: {
                return 2;
            }
        }
        throw new AssertionFailure("undefined join type " + astJoinType);
    }

    public void processJoins(QueryNode query) {
        ArrayList fromElements;
        final FromClause fromClause = query.getFromClause();
        if (DotNode.useThetaStyleImplicitJoins) {
            fromElements = new ArrayList();
            ListIterator liter = fromClause.getFromElements().listIterator(fromClause.getFromElements().size());
            while (liter.hasPrevious()) {
                fromElements.add(liter.previous());
            }
        } else {
            fromElements = fromClause.getFromElements();
        }
        Iterator iter = fromElements.iterator();
        while (iter.hasNext()) {
            final FromElement fromElement = (FromElement)iter.next();
            JoinSequence join = fromElement.getJoinSequence();
            join.setSelector(new JoinSequence.Selector(){

                public boolean includeSubclasses(String alias) {
                    boolean containsTableAlias = fromClause.containsTableAlias(alias);
                    if (fromElement.isDereferencedBySubclassProperty()) {
                        log.trace("forcing inclusion of extra joins [alias=" + alias + ", containsTableAlias=" + containsTableAlias + "]");
                        return true;
                    }
                    boolean shallowQuery = JoinProcessor.this.walker.isShallowQuery();
                    boolean includeSubclasses = fromElement.isIncludeSubclasses();
                    boolean subQuery = fromClause.isSubQuery();
                    return includeSubclasses && containsTableAlias && !subQuery && !shallowQuery;
                }
            });
            this.addJoinNodes(query, join, fromElement);
        }
    }

    private void addJoinNodes(QueryNode query, JoinSequence join, FromElement fromElement) {
        JoinFragment joinFragment = join.toJoinFragment(this.walker.getEnabledFilters(), fromElement.useFromFragment() || fromElement.isDereferencedBySuperclassOrSubclassProperty(), fromElement.getWithClauseFragment(), fromElement.getWithClauseJoinAlias());
        String frag = joinFragment.toFromFragmentString();
        String whereFrag = joinFragment.toWhereFragmentString();
        if (fromElement.getType() == 130 && (join.isThetaStyle() || StringHelper.isNotEmpty(whereFrag))) {
            fromElement.setType(128);
            fromElement.getJoinSequence().setUseThetaStyle(true);
        }
        if (fromElement.useFromFragment()) {
            String fromFragment = this.processFromFragment(frag, join).trim();
            if (log.isDebugEnabled()) {
                log.debug("Using FROM fragment [" + fromFragment + "]");
            }
            JoinProcessor.processDynamicFilterParameters(fromFragment, fromElement, this.walker);
        }
        this.syntheticAndFactory.addWhereFragment(joinFragment, whereFrag, query, fromElement, this.walker);
    }

    private String processFromFragment(String frag, JoinSequence join) {
        String fromFragment = frag.trim();
        if (fromFragment.startsWith(", ")) {
            fromFragment = fromFragment.substring(2);
        }
        return fromFragment;
    }

    public static void processDynamicFilterParameters(String sqlFragment, ParameterContainer container, HqlSqlWalker walker) {
        if (walker.getEnabledFilters().isEmpty() && !JoinProcessor.hasDynamicFilterParam(sqlFragment) && !JoinProcessor.hasCollectionFilterParam(sqlFragment)) {
            return;
        }
        Dialect dialect = walker.getSessionFactoryHelper().getFactory().getDialect();
        String symbols = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer tokens = new StringTokenizer(sqlFragment, symbols, true);
        StringBuffer result = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.startsWith(":")) {
                String filterParameterName = token.substring(1);
                String[] parts = QueryParameters.parseFilterParameterName(filterParameterName);
                FilterImpl filter = (FilterImpl)walker.getEnabledFilters().get(parts[0]);
                Object value = filter.getParameter(parts[1]);
                Type type = filter.getFilterDefinition().getParameterType(parts[1]);
                String typeBindFragment = StringHelper.join(",", ArrayHelper.fillArray("?", type.getColumnSpan(walker.getSessionFactoryHelper().getFactory())));
                String bindFragment = value != null && (class$java$util$Collection == null ? JoinProcessor.class$("java.util.Collection") : class$java$util$Collection).isInstance(value) ? StringHelper.join(",", ArrayHelper.fillArray(typeBindFragment, ((Collection)value).size())) : typeBindFragment;
                result.append(bindFragment);
                container.addEmbeddedParameter(new DynamicFilterParameterSpecification(parts[0], parts[1], type));
                continue;
            }
            result.append(token);
        }
        container.setText(result.toString());
    }

    private static boolean hasDynamicFilterParam(String sqlFragment) {
        return sqlFragment.indexOf(":") < 0;
    }

    private static boolean hasCollectionFilterParam(String sqlFragment) {
        return sqlFragment.indexOf("?") < 0;
    }
}

