/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.ReplicationException;
import org.exoplatform.services.jcr.ext.replication.transport.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.transport.MemberAddress;
import org.exoplatform.services.jcr.ext.replication.transport.PacketTransformer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;

public class ReplicationChannelManager
extends ChannelManager {
    private static final Log LOG = ExoLogger.getLogger("exo.jcr.component.ext.ReplicationChannelManager");
    private String testChannelName;

    public ReplicationChannelManager(String channelConfig, String channelName) {
        super(channelConfig, channelName, 0);
    }

    public Object handle(Message message) {
        if (this.isConnected()) {
            try {
                this.packetsHandler.add(PacketTransformer.getAsPacket(message.getBuffer()), new MemberAddress(message.getSrc()));
                if (this.channel != null || this.channel.getView() != null) {
                    this.packetsHandler.handle();
                } else {
                    LOG.warn("No members found or channel closed, queue message " + message);
                }
                return new String("Success");
            }
            catch (IOException e) {
                LOG.error("Message handler error " + e, e);
                return e.getMessage();
            }
            catch (ClassNotFoundException e) {
                LOG.error("Message handler error " + e, e);
                return e.getMessage();
            }
        }
        LOG.warn("Channel is closed but message received " + message);
        return new String("Disconnected");
    }

    public synchronized void send(byte[] buffer) {
        Message msg = new Message(null, null, buffer);
        this.dispatcher.castMessage(null, msg, 6, 0L);
    }

    public synchronized void sendBigPacket(byte[] data, Packet packet) throws Exception {
        int len;
        long totalPacketCount = this.getPacketCount(data.length, 16384L);
        int offset = 0;
        while ((len = data.length - offset) > 0) {
            int l = len > 16384 ? 16384 : len;
            byte[] buf = new byte[l];
            System.arraycopy(data, offset, buf, 0, l);
            Packet bigPacket = new Packet(27, packet.getIdentifier(), totalPacketCount, data.length, offset, buf);
            this.sendPacket(bigPacket);
            offset += l;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Send of damp --> " + bigPacket.getByteArray().length);
        }
    }

    public synchronized void sendBinaryFile(String filePath, String ownerName, String identifier, String systemId, int packetType) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Begin send : " + filePath);
        }
        File f = new File(filePath);
        long packetCount = this.getPacketCount(PrivilegedFileHelper.length(f), 16384L);
        FileInputStream in = PrivilegedFileHelper.fileInputStream(f);
        byte[] buf = new byte[16384];
        long offset = 0L;
        int len = in.read(buf);
        if (len < 16384) {
            byte[] b = new byte[len];
            System.arraycopy(buf, 0, b, 0, len);
            buf = b;
        }
        Packet packet = new Packet(packetType, systemId, identifier, ownerName, f.getName(), packetCount, offset, buf);
        this.sendPacket(packet);
        offset += (long)len;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send packet type [" + packetType + "] --> " + offset);
        }
        while ((len = in.read(buf)) > 0) {
            if (len < 16384) {
                byte[] b = new byte[len];
                System.arraycopy(buf, 0, b, 0, len);
                buf = b;
            }
            packet = new Packet(packetType, systemId, identifier, ownerName, f.getName(), packetCount, offset, buf);
            this.sendPacket(packet);
            offset += (long)len;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Send packet type [" + packetType + "] --> " + offset);
        }
        in.close();
    }

    private long getPacketCount(long contentLength, long packetSize) {
        long count;
        return count += (count = contentLength / packetSize) * packetSize - contentLength != 0L ? 1L : 0L;
    }

    public void setAllowConnect(boolean allowConnect) {
        this.testChannelName = !allowConnect ? this.channelName + Math.round(Math.random() * 127.0) : null;
    }

    public void setAllowConnect(boolean allowConnect, int id) {
        this.testChannelName = !allowConnect ? this.channelName + id : null;
    }

    public void connect() throws ReplicationException {
        try {
            if (this.channel == null) {
                this.channel = new JChannel(this.channelConfig);
                this.channel.setOpt(5, (Object)Boolean.TRUE);
                this.channel.setOpt(6, (Object)Boolean.TRUE);
                this.dispatcher = new MessageDispatcher((Channel)this.channel, null, null, null);
                this.dispatcher.setRequestHandler((RequestHandler)this);
                this.dispatcher.setMembershipListener((MembershipListener)this);
            }
        }
        catch (ChannelException e) {
            throw new ReplicationException("Can't create JGroups channel", e);
        }
        LOG.info("Channel name : " + this.channelName);
        try {
            if (this.testChannelName == null) {
                this.channel.connect(this.channelName);
            } else {
                this.channel.connect(this.testChannelName);
            }
            this.state = 2;
        }
        catch (ChannelException e) {
            throw new ReplicationException("Can't connect to JGroups channel", e);
        }
    }
}

