/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms;

import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanHelper;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBClean {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBClean");
    protected final Connection connection;
    protected final Pattern dbObjectNamePattern;
    protected final List<String> cleanScripts = new ArrayList<String>();
    protected final DBCleanHelper dbCleanHelper;

    public DBClean(Connection connection, List<String> cleanScripts) {
        this(connection, cleanScripts, null);
    }

    public DBClean(Connection connection, List<String> cleanScripts, DBCleanHelper dbCleanHelper) {
        this.dbObjectNamePattern = Pattern.compile(DBInitializer.SQL_OBJECTNAME, 2);
        this.connection = connection;
        this.cleanScripts.addAll(cleanScripts);
        this.dbCleanHelper = dbCleanHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clean() throws SQLException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        String sql = null;
        Statement st = null;
        try {
            st = this.connection.createStatement();
            for (String scr : this.cleanScripts) {
                String s = this.cleanWhitespaces(scr.trim());
                if (s.length() <= 0 || !this.canExecuteQuery(sql = s)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Execute script: \n[" + sql + "]"));
                }
                this.executeQuery(st, sql);
            }
            if (this.dbCleanHelper != null) {
                this.dbCleanHelper.clean();
            }
            Object var8_7 = null;
            if (st == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (st == null) throw throwable;
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the Statement." + e));
            }
            throw throwable;
        }
        try {
            st.close();
            return;
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the Statement." + e));
        }
    }

    protected boolean canExecuteQuery(String sql) throws SQLException {
        Matcher tMatcher = this.dbObjectNamePattern.matcher(sql);
        while (tMatcher.find()) {
            String tableName = sql.substring(tMatcher.start(), tMatcher.end());
            if (this.isTableExists(this.connection, tableName)) continue;
            LOG.warn((Object)("Table [" + tableName + "] from query [" + sql + "] was not found. So query will not be executed."));
            return false;
        }
        return true;
    }

    protected void executeQuery(final Statement statement, final String sql) throws SQLException {
        SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                statement.executeUpdate(sql);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTableExists(Connection conn, String tableName) throws SQLException {
        boolean bl;
        ResultSet trs = conn.getMetaData().getTables(null, null, tableName, null);
        try {
            boolean res = false;
            while (trs.next()) {
                res = true;
            }
            bl = res;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                trs.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the ResultSet: " + e));
            }
            throw throwable;
        }
        try {
            trs.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the ResultSet: " + e));
        }
        return bl;
    }

    private String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }
}

