/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.ispn.ChangesKey;
import org.exoplatform.services.jcr.impl.core.query.ispn.ISPNIndexInfos;
import org.exoplatform.services.jcr.impl.core.query.ispn.ISPNIndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.ispn.IndexerCacheStore;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.loaders.CacheLoaderManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISPNIndexChangesFilter
extends IndexerChangesFilter {
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.ISPNIndexChangesFilter");
    public static final String PARAM_INFINISPAN_CACHESTORE_CLASS = "infinispan-cachestore-classname";
    private final Cache<Serializable, Object> cache;
    private final String wsId;

    public ISPNIndexChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws IOException, RepositoryException, RepositoryConfigurationException {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        this.wsId = searchManager.getWsId();
        ISPNCacheFactory factory = new ISPNCacheFactory(cfm);
        config.putParameterValue(PARAM_INFINISPAN_CACHESTORE_CLASS, IndexerCacheStore.class.getName());
        this.cache = factory.createCache("Indexer_" + searchManager.getWsId(), config);
        CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)this.cache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
        IndexerCacheStore cacheStore = (IndexerCacheStore)cacheLoaderManager.getCacheLoader();
        cacheStore.register(searchManager, parentSearchManager, handler, parentHandler);
        IndexerIoModeHandler modeHandler = cacheStore.getModeHandler();
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (!parentHandler.isInitialized()) {
            parentHandler.setIndexInfos(new ISPNIndexInfos(searchManager.getWsId(), this.cache, true, modeHandler));
            parentHandler.setIndexUpdateMonitor(new ISPNIndexUpdateMonitor(searchManager.getWsId(), this.cache, true, modeHandler));
            parentHandler.init();
        }
        if (!handler.isInitialized()) {
            handler.setIndexInfos(new ISPNIndexInfos(searchManager.getWsId(), this.cache, false, modeHandler));
            handler.setIndexUpdateMonitor(new ISPNIndexUpdateMonitor(searchManager.getWsId(), this.cache, false, modeHandler));
            handler.init();
        }
    }

    @Override
    protected void doUpdateIndex(Set<String> removedNodes, Set<String> addedNodes, Set<String> parentRemovedNodes, Set<String> parentAddedNodes) {
        ChangesHolder changes = this.searchManager.getChanges(removedNodes, addedNodes);
        ChangesHolder parentChanges = this.parentSearchManager.getChanges(parentRemovedNodes, parentAddedNodes);
        if (changes == null && parentChanges == null) {
            return;
        }
        ChangesKey changesKey = new ChangesKey(this.wsId, IdGenerator.generate());
        try {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LOCKING});
            PrivilegedISPNCacheHelper.put(this.cache, changesKey, new ChangesFilterListsWrapper(changes, parentChanges));
        }
        catch (CacheException e) {
            this.log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.logErrorChanges(this.handler, removedNodes, addedNodes);
            this.logErrorChanges(this.parentHandler, parentRemovedNodes, parentAddedNodes);
        }
    }

    private void logErrorChanges(QueryHandler logHandler, Set<String> removedNodes, Set<String> addedNodes) {
        try {
            logHandler.logErrorChanges(addedNodes, removedNodes);
        }
        catch (IOException ioe) {
            this.log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
        }
    }

    @Override
    public boolean isShared() {
        return true;
    }
}

