/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.indexing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.jcr.datamodel.NodeDataIndexing;
import org.exoplatform.services.jcr.impl.core.query.NodeDataIndexingIterator;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcNodeDataIndexingIterator
implements NodeDataIndexingIterator {
    private final GenericConnectionFactory connFactory;
    private final int pageSize;
    private final AtomicInteger offset = new AtomicInteger(0);
    private final AtomicBoolean hasNext = new AtomicBoolean(true);
    private final AtomicReference<String> lastNodeId = new AtomicReference<String>("");
    private static final AtomicInteger page = new AtomicInteger();
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JdbcIndexingDataIterator");

    public JdbcNodeDataIndexingIterator(GenericConnectionFactory connFactory, int pageSize) throws RepositoryException {
        this.connFactory = connFactory;
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeDataIndexing> next() throws RepositoryException {
        Object object;
        if (!this.hasNext()) {
            return new ArrayList<NodeDataIndexing>();
        }
        JDBCStorageConnection conn = (JDBCStorageConnection)this.connFactory.openConnection();
        try {
            int currentPage;
            String currentLastNodeId;
            int currentOffset;
            JdbcNodeDataIndexingIterator jdbcNodeDataIndexingIterator = this;
            synchronized (jdbcNodeDataIndexingIterator) {
                currentOffset = this.offset.getAndAdd(this.pageSize);
                currentLastNodeId = this.lastNodeId.get();
                currentPage = page.incrementAndGet();
            }
            long time = System.currentTimeMillis();
            List<NodeDataIndexing> result = conn.getNodesAndProperties(currentLastNodeId, currentOffset, this.pageSize);
            if (PropertyManager.isDevelopping()) {
                LOG.info((Object)("Page = " + currentPage + " Offset = " + currentOffset + " LastNodeId = '" + currentLastNodeId + "', query time = " + (System.currentTimeMillis() - time) + " ms, from '" + (result.isEmpty() ? "unknown" : result.get(0).getIdentifier()) + "' to '" + (result.isEmpty() ? "unknown" : result.get(result.size() - 1).getIdentifier()) + "'"));
            }
            this.hasNext.compareAndSet(true, result.size() == this.pageSize);
            if (this.hasNext() && this.connFactory.isIDNeededForPaging()) {
                object = this;
                synchronized (object) {
                    this.lastNodeId.set(result.get(result.size() - 1).getIdentifier());
                    this.offset.set((page.get() - currentPage) * this.pageSize);
                }
            }
            object = result;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return object;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext.get();
    }
}

