/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource.config.tasks;

import javax.servlet.ServletContext;
import org.exoplatform.portal.resource.SkinDependentManager;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.tasks.AbstractSkinModule;
import org.exoplatform.portal.resource.config.tasks.SkinConfigTask;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PortletSkinTask
extends AbstractSkinModule
implements SkinConfigTask {
    private String applicationName;
    private String portletName;

    public PortletSkinTask() {
        super("Default");
        this.overwrite = true;
    }

    private void bindingApplicationName(Element element) {
        NodeList nodes = element.getElementsByTagName("application-name");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        String applicationName = nodes.item(0).getFirstChild().getNodeValue();
        this.setApplicationName(applicationName);
    }

    private void bindingPortletName(Element element) {
        NodeList nodes = element.getElementsByTagName("portlet-name");
        if (nodes == null || nodes.getLength() < 1) {
            return;
        }
        String portletName = nodes.item(0).getFirstChild().getNodeValue();
        this.setPortletName(portletName);
    }

    public void setApplicationName(String _applicationName) {
        this.applicationName = _applicationName;
    }

    public void setPortletName(String _portletName) {
        this.portletName = _portletName;
    }

    public void execute(SkinService skinService, ServletContext scontext) {
        if (this.portletName == null || this.skinName == null || this.cssPath == null) {
            return;
        }
        if (this.applicationName == null) {
            this.applicationName = scontext.getContextPath();
        }
        String moduleName = this.applicationName + "/" + this.portletName;
        String contextPath = scontext.getContextPath();
        String fullCSSPath = contextPath + this.cssPath;
        skinService.addSkin(moduleName, this.skinName, fullCSSPath, scontext, this.overwrite);
        this.updateSkinDependentManager(contextPath, moduleName, this.skinName);
    }

    private void updateSkinDependentManager(String webApp, String moduleName, String skinName) {
        SkinDependentManager.addPortletSkin(webApp, moduleName, skinName);
        SkinDependentManager.addSkinDeployedInApp(webApp, skinName);
    }

    public void binding(Element elemt) {
        this.bindingApplicationName(elemt);
        this.bindingPortletName(elemt);
        this.bindingCSSPath(elemt);
        this.bindingSkinName(elemt);
        this.bindingOverwrite(elemt);
    }
}

