/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class GenericCQConnectionFactory
extends GenericConnectionFactory {
    protected GenericCQConnectionFactory(DataSource dataSource, String dbDriver, String dbUrl, String dbUserName, String dbPassword, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
        super(dataSource, dbDriver, dbUrl, dbUserName, dbPassword, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public GenericCQConnectionFactory(DataSource dataSource, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
        this(dataSource, null, null, null, null, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public GenericCQConnectionFactory(String dbDriver, String dbUrl, String dbUserName, String dbPassword, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws RepositoryException {
        this(null, dbDriver, dbUrl, dbUserName, dbPassword, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
        try {
            Class.forName(dbDriver).newInstance();
        }
        catch (InstantiationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        return this.openConnection(false);
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.multiDb) {
                return new MultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            return new SingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Connection getJdbcConnection(boolean readOnly) throws RepositoryException {
        try {
            Connection conn;
            Connection connection = this.dbDataSource != null ? this.dbDataSource.getConnection() : (conn = this.dbUserName != null ? DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword) : DriverManager.getConnection(this.dbUrl));
            if (readOnly) {
                conn.setReadOnly(readOnly);
            }
            return conn;
        }
        catch (SQLException e) {
            String err = "Error of JDBC connection open. SQLException: " + e.getMessage() + ", SQLState: " + e.getSQLState() + ", VendorError: " + e.getErrorCode();
            throw new RepositoryException(err, (Throwable)e);
        }
    }

    public Connection getJdbcConnection() throws RepositoryException {
        return this.getJdbcConnection(false);
    }

    public boolean isReindexingSupport() {
        return true;
    }
}

