/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class TCPPING
extends Discovery {
    int port_range = 1;
    List<Address> initial_hosts = null;
    static final String name = "TCPPING";

    @Override
    public String getName() {
        return name;
    }

    public List<Address> getInitialHosts() {
        return this.initial_hosts;
    }

    @Override
    public boolean setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
        String str = props.getProperty("port_range");
        if (str != null) {
            this.port_range = Integer.parseInt(str);
            if (this.port_range < 1) {
                this.port_range = 1;
            }
            props.remove("port_range");
        }
        if ((str = Util.getProperty(new String[]{"jgroups.tcpping.initial_hosts"}, props, "initial_hosts", false, null)) != null) {
            props.remove("initial_hosts");
            try {
                this.initial_hosts = this.createInitialHosts(str);
            }
            catch (UnknownHostException e) {
                this.log.error((Object)"failed creating initial list of hosts", (Throwable)e);
                return false;
            }
        }
        return super.setProperties(props);
    }

    @Override
    public void localAddressSet(Address addr) {
        if (this.initial_hosts != null && addr != null && this.initial_hosts.contains(addr)) {
            this.initial_hosts.remove(addr);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[SET_LOCAL_ADDRESS]: removing my own address (" + addr + ") from initial_hosts; initial_hosts=" + this.initial_hosts));
            }
        }
    }

    @Override
    public void sendGetMembersRequest(Promise promise) throws Exception {
        for (final Address addr : this.initial_hosts) {
            final Message msg = new Message(addr, null, null);
            msg.setFlag((byte)1);
            msg.putHeader(name, new PingHeader(1, null));
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest()));
            }
            this.down_prot.down(new Event(1, msg));
            this.timer.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            TCPPING.this.down_prot.down(new Event(1, msg));
                        }
                        catch (Exception ex) {
                            if (!TCPPING.this.log.isErrorEnabled()) break block2;
                            TCPPING.this.log.error((Object)("failed sending discovery request to " + addr), (Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    private List<Address> createInitialHosts(String l) throws UnknownHostException {
        StringTokenizer tok = new StringTokenizer(l, ",");
        ArrayList<Address> retval = new ArrayList<Address>();
        while (tok.hasMoreTokens()) {
            try {
                int port;
                String t = tok.nextToken().trim();
                String host = t.substring(0, t.indexOf(91));
                host = host.trim();
                for (int i = port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93))); i < port + this.port_range; ++i) {
                    IpAddress addr = new IpAddress(host, i);
                    retval.add(addr);
                }
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exeption is " + e));
            }
        }
        return retval;
    }
}

