/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import java.net.URI;
import junit.framework.TestCase;

public class FilePositionTest
extends TestCase {
    public final void testInstance1() {
        InputSource is = new InputSource(URI.create("t:///foo"));
        FilePosition inst = FilePosition.instance(is, 1, 1, 1);
        FilePositionTest.assertEquals((Object)is, (Object)inst.source());
        FilePositionTest.assertEquals((int)1, (int)inst.startLineNo());
        FilePositionTest.assertEquals((int)1, (int)inst.startCharInFile());
        FilePositionTest.assertEquals((int)1, (int)inst.startCharInLine());
        FilePositionTest.assertEquals((int)1, (int)inst.endLineNo());
        FilePositionTest.assertEquals((int)1, (int)inst.endCharInFile());
        FilePositionTest.assertEquals((int)1, (int)inst.endCharInLine());
        FilePositionTest.assertEquals((int)0, (int)inst.length());
        FilePositionTest.assertEquals((String)"foo:1+1@1", (String)inst.toString());
    }

    public final void testInstance2() {
        InputSource is = new InputSource(URI.create("t:///foo"));
        FilePosition inst = FilePosition.instance(is, 1, 1, 1, 1);
        FilePositionTest.assertEquals((Object)is, (Object)inst.source());
        FilePositionTest.assertEquals((int)1, (int)inst.startLineNo());
        FilePositionTest.assertEquals((int)1, (int)inst.startCharInFile());
        FilePositionTest.assertEquals((int)1, (int)inst.startCharInLine());
        FilePositionTest.assertEquals((int)1, (int)inst.endLineNo());
        FilePositionTest.assertEquals((int)2, (int)inst.endCharInFile());
        FilePositionTest.assertEquals((int)2, (int)inst.endCharInLine());
        FilePositionTest.assertEquals((int)1, (int)inst.length());
        FilePositionTest.assertEquals((String)"foo:1+1@1 - 2@2", (String)inst.toString());
    }

    public final void testInstance3() {
        InputSource is = new InputSource(URI.create("t:///foo"));
        FilePosition inst = FilePosition.instance(is, 2, 30, 2, 3);
        FilePositionTest.assertEquals((Object)is, (Object)inst.source());
        FilePositionTest.assertEquals((int)2, (int)inst.startLineNo());
        FilePositionTest.assertEquals((int)30, (int)inst.startCharInFile());
        FilePositionTest.assertEquals((int)2, (int)inst.startCharInLine());
        FilePositionTest.assertEquals((int)2, (int)inst.endLineNo());
        FilePositionTest.assertEquals((int)33, (int)inst.endCharInFile());
        FilePositionTest.assertEquals((int)5, (int)inst.endCharInLine());
        FilePositionTest.assertEquals((int)3, (int)inst.length());
        FilePositionTest.assertEquals((String)"foo:2+2@30 - 5@33", (String)inst.toString());
    }

    public final void testInstance4() {
        InputSource is = new InputSource(URI.create("t:///foo"));
        FilePosition inst = FilePosition.instance(is, 2, 30, 1);
        FilePositionTest.assertEquals((Object)is, (Object)inst.source());
        FilePositionTest.assertEquals((int)2, (int)inst.startLineNo());
        FilePositionTest.assertEquals((int)30, (int)inst.startCharInFile());
        FilePositionTest.assertEquals((int)1, (int)inst.startCharInLine());
        FilePositionTest.assertEquals((int)2, (int)inst.endLineNo());
        FilePositionTest.assertEquals((int)30, (int)inst.endCharInFile());
        FilePositionTest.assertEquals((int)1, (int)inst.endCharInLine());
        FilePositionTest.assertEquals((int)0, (int)inst.length());
        FilePositionTest.assertEquals((String)"foo:2+1@30", (String)inst.toString());
    }

    public final void testFilePositionFor() {
        InputSource is = new InputSource(URI.create("t:///bar"));
        FilePosition inst = FilePosition.fromLinePositions(is, 1, 1, 10, 100);
        FilePositionTest.assertEquals((Object)is, (Object)inst.source());
        FilePositionTest.assertEquals((int)1, (int)inst.startLineNo());
        FilePositionTest.assertEquals((int)1, (int)inst.startCharInLine());
        FilePositionTest.assertEquals((int)10, (int)inst.endLineNo());
        FilePositionTest.assertEquals((int)100, (int)inst.endCharInLine());
    }
}

