/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.io.IOException;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.PathParamDescriptor;
import org.exoplatform.web.controller.regexp.RENode;
import org.exoplatform.web.controller.regexp.REParser;
import org.exoplatform.web.controller.regexp.RERenderer;
import org.exoplatform.web.controller.regexp.SyntaxException;
import org.exoplatform.web.controller.router.EncodingMode;
import org.exoplatform.web.controller.router.MalformedRouteException;
import org.exoplatform.web.controller.router.Param;
import org.exoplatform.web.controller.router.Regex;
import org.exoplatform.web.controller.router.RouteEscaper;
import org.exoplatform.web.controller.router.Router;

class PathParam
extends Param {
    final EncodingMode encodingMode;
    final String routingRegex;
    final Regex renderingPattern;

    static PathParam create(QualifiedName name, Router router) {
        return PathParam.create(new PathParamDescriptor(name), router);
    }

    static PathParam create(PathParamDescriptor descriptor, Router router) {
        if (descriptor == null) {
            throw new NullPointerException("No null descriptor accepted");
        }
        String regex = null;
        EncodingMode encodingMode = EncodingMode.FORM;
        if (descriptor != null) {
            regex = descriptor.getPattern();
            encodingMode = descriptor.getEncodingMode();
        }
        if (regex == null) {
            regex = encodingMode == EncodingMode.FORM ? ".+" : "[^/]+";
        }
        StringBuilder renderingRegex = new StringBuilder();
        StringBuilder routingRegex = new StringBuilder();
        try {
            REParser parser = new REParser(regex);
            RENode.Disjunction routingDisjunction = parser.parseDisjunction();
            if (encodingMode == EncodingMode.FORM) {
                RouteEscaper escaper = new RouteEscaper('/', '_');
                escaper.visit(routingDisjunction);
            }
            new RERenderer().render(routingDisjunction, routingRegex);
            parser.reset();
            RENode.Disjunction renderingDisjunction = parser.parseDisjunction();
            renderingRegex.append("^");
            new RERenderer().render(renderingDisjunction, renderingRegex);
            renderingRegex.append("$");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedRouteException e) {
            throw new RuntimeException(e);
        }
        return new PathParam(descriptor.getQualifiedName(), encodingMode, routingRegex.toString(), router.compile(renderingRegex.toString()));
    }

    PathParam(QualifiedName name, EncodingMode encodingMode, String routingRegex, Regex renderingRegex) {
        super(name);
        if (renderingRegex == null) {
            throw new NullPointerException("No null pattern accepted");
        }
        this.encodingMode = encodingMode;
        this.routingRegex = routingRegex;
        this.renderingPattern = renderingRegex;
    }

    public String toString() {
        return "PathParam[name=" + this.name + ",encodingMode=" + (Object)((Object)this.encodingMode) + ",pattern=" + this.renderingPattern + "]";
    }
}

