/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/portal/webui/application/UIApplicationList.gtmpl", events={@EventConfig(listeners={SelectCategoryActionListener.class})})
public class UIApplicationList
extends UIContainer {
    private List<ApplicationCategory> categories;
    private ApplicationCategory selectedCategory;

    public Application getApplication(String id) throws Exception {
        for (ApplicationCategory category : this.getCategories()) {
            List items = category.getApplications();
            for (Application item : items) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
        }
        return null;
    }

    public ApplicationCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(String categoryName) {
        for (ApplicationCategory category : this.getCategories()) {
            if (!category.getName().equals(categoryName)) continue;
            this.selectedCategory = category;
        }
    }

    public List<Application> getApplications() {
        if (this.selectedCategory == null) {
            return null;
        }
        List apps = this.selectedCategory.getApplications();
        GadgetRegistryService gadgetService = (GadgetRegistryService)this.getApplicationComponent(GadgetRegistryService.class);
        for (Application app : apps) {
            if (!ApplicationType.GADGET.equals(app.getType())) continue;
            try {
                Gadget gadget = gadgetService.getGadget(app.getApplicationName());
                if (gadget == null) continue;
                app.setIconURL(gadget.getThumbnail());
            }
            catch (Exception e) {}
        }
        return apps;
    }

    public List<ApplicationCategory> getCategories() {
        try {
            if (this.categories == null) {
                this.initAllCategories();
            }
            return this.categories;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void initAllCategories() throws Exception {
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        if (remoteUser == null || remoteUser.equals("")) {
            return;
        }
        ApplicationRegistryService service = (ApplicationRegistryService)this.getApplicationComponent(ApplicationRegistryService.class);
        UserACL userACL = (UserACL)Util.getUIPortalApplication().getApplicationComponent(UserACL.class);
        Comparator<Application> appComparator = new Comparator<Application>(){

            @Override
            public int compare(Application p_1, Application p_2) {
                return p_1.getDisplayName().compareToIgnoreCase(p_2.getDisplayName());
            }
        };
        Comparator<ApplicationCategory> cateComparator = new Comparator<ApplicationCategory>(){

            @Override
            public int compare(ApplicationCategory p_1, ApplicationCategory p_2) {
                return p_1.getDisplayName().compareToIgnoreCase(p_2.getDisplayName());
            }
        };
        List allCategories = service.getApplicationCategories(remoteUser, new ApplicationType[0]);
        this.categories = new ArrayList<ApplicationCategory>();
        for (ApplicationCategory category : allCategories) {
            String p;
            Iterator i$;
            List apps = category.getApplications();
            List accessPermission = category.getAccessPermissions();
            if (accessPermission == null || !(i$ = accessPermission.iterator()).hasNext() || !userACL.hasPermission(p = (String)i$.next())) continue;
            if (apps.size() > 0) {
                Collections.sort(apps, appComparator);
            }
            this.categories.add(category);
        }
        if (this.categories.size() > 0) {
            Collections.sort(this.categories, cateComparator);
            this.selectedCategory = this.categories.get(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectCategoryActionListener
    extends EventListener<UIApplicationList> {
        public void execute(Event<UIApplicationList> event) throws Exception {
            String category = event.getRequestContext().getRequestParameter("objectId");
            UIApplicationList uiApplicationList = (UIApplicationList)((Object)event.getSource());
            uiApplicationList.setSelectedCategory(category);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplicationList);
        }
    }
}

