/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authz.aop;

import java.lang.annotation.Annotation;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.UnauthenticatedException;
import org.jsecurity.authz.annotation.RequiresGuest;
import org.jsecurity.authz.aop.AuthorizingAnnotationHandler;

public class GuestAnnotationHandler
extends AuthorizingAnnotationHandler {
    public GuestAnnotationHandler() {
        super(RequiresGuest.class);
    }

    public void assertAuthorized(Annotation a) throws AuthorizationException {
        if (a instanceof RequiresGuest && this.getSubject().getPrincipal() != null) {
            throw new UnauthenticatedException("Attempting to perform a guest-only operation.  The current Subject is not a guest (they have been authenticated or remembered from a previous login).  Access denied.");
        }
    }
}

