/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.util;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.JSecurityException;
import org.jsecurity.util.Destroyable;
import org.jsecurity.util.Initializable;

public abstract class LifecycleUtils {
    private static final Log log = LogFactory.getLog(LifecycleUtils.class);

    public static void init(Object o) throws JSecurityException {
        if (o instanceof Initializable) {
            LifecycleUtils.init((Initializable)o);
        }
    }

    public static void init(Initializable initializable) throws JSecurityException {
        initializable.init();
    }

    public static void init(Collection c) throws JSecurityException {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (Object o : c) {
            LifecycleUtils.init(o);
        }
    }

    public static void destroy(Object o) {
        if (o instanceof Destroyable) {
            LifecycleUtils.destroy((Destroyable)o);
        }
    }

    public static void destroy(Destroyable d) {
        block3: {
            if (d != null) {
                try {
                    d.destroy();
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block3;
                    String msg = "Unable to cleanly destroy instance [" + d + "] of type [" + d.getClass().getName() + "].";
                    log.debug((Object)msg, t);
                }
            }
        }
    }

    public static void destroy(Collection c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (Object o : c) {
            LifecycleUtils.destroy(o);
        }
    }
}

