/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;

public class CacheableMembershipTypeHandlerImpl
implements MembershipTypeHandler {
    private final ExoCache membershipTypeCache;
    private final ExoCache membershipCache;
    private final MembershipTypeHandler membershipTypeHandler;

    public CacheableMembershipTypeHandlerImpl(OrganizationCacheHandler organizationCacheHandler, MembershipTypeHandler membershipTypeHandler) {
        this.membershipTypeCache = organizationCacheHandler.getMembershipTypeCache();
        this.membershipCache = organizationCacheHandler.getMembershipCache();
        this.membershipTypeHandler = membershipTypeHandler;
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        MembershipType membershipType = this.membershipTypeHandler.createMembershipType(mt, broadcast);
        this.membershipTypeCache.put((Serializable)((Object)membershipType.getName()), (Object)membershipType);
        return membershipType;
    }

    public MembershipType createMembershipTypeInstance() {
        return this.membershipTypeHandler.createMembershipTypeInstance();
    }

    public MembershipType findMembershipType(String name) throws Exception {
        MembershipType membershipType = (MembershipType)this.membershipTypeCache.get((Serializable)((Object)name));
        if (membershipType != null) {
            return membershipType;
        }
        membershipType = this.membershipTypeHandler.findMembershipType(name);
        if (membershipType != null) {
            this.membershipTypeCache.put((Serializable)((Object)name), (Object)membershipType);
        }
        return membershipType;
    }

    public Collection findMembershipTypes() throws Exception {
        Collection membershipTypes = this.membershipTypeHandler.findMembershipTypes();
        for (MembershipType membershipType : membershipTypes) {
            this.membershipTypeCache.put((Serializable)((Object)membershipType.getName()), (Object)membershipType);
        }
        return membershipTypes;
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        MembershipType membershipType = this.membershipTypeHandler.removeMembershipType(name, broadcast);
        if (membershipType != null) {
            this.membershipTypeCache.remove((Serializable)((Object)name));
            List memberships = this.membershipCache.getCachedObjects();
            for (Membership membership : memberships) {
                if (!membership.getMembershipType().equals(name)) continue;
                this.membershipCache.remove((Serializable)((Object)membership.getId()));
                this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
            }
        }
        return membershipType;
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        MembershipType membershipType = this.membershipTypeHandler.saveMembershipType(mt, broadcast);
        this.membershipTypeCache.put((Serializable)((Object)membershipType.getName()), (Object)membershipType);
        return membershipType;
    }

    public void addMembershipTypeEventListener(MembershipTypeEventListener listener) {
        this.membershipTypeHandler.addMembershipTypeEventListener(listener);
    }

    public void removeMembershipTypeEventListener(MembershipTypeEventListener listener) {
        this.membershipTypeHandler.removeMembershipTypeEventListener(listener);
    }
}

