/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;

public abstract class NullItemData
implements ItemData,
Externalizable {
    public static final String NULL_ID = "_null_id";
    private String id;
    private String parentId;
    private QPathEntry name;
    private QPath path;

    public NullItemData(NodeData parent, QPathEntry name) {
        this.parentId = parent.getIdentifier();
        this.path = QPath.makeChildPath(parent.getQPath(), name);
        this.name = name;
        this.id = NULL_ID;
    }

    public NullItemData(String id) {
        this.id = id;
    }

    public NullItemData() {
        this(NULL_ID);
    }

    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getParentIdentifier() {
        return this.parentId;
    }

    public int getPersistedVersion() {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public QPath getQPath() {
        return this.path;
    }

    public QPathEntry getName() {
        return this.name;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        this.id = new String(buf, "UTF-8");
        int length = in.readInt();
        if (length > 0) {
            buf = new byte[length];
            in.readFully(buf);
            this.parentId = new String(buf, "UTF-8");
        }
        if ((length = in.readInt()) > 0) {
            buf = new byte[length];
            in.readFully(buf);
            try {
                this.name = QPathEntry.parse(new String(buf, "UTF-8"));
            }
            catch (Exception e) {
                throw new IOException("Deserialization error, could not parse the name. ", e);
            }
        }
        if ((length = in.readInt()) > 0) {
            buf = new byte[length];
            in.readFully(buf);
            try {
                this.path = QPath.parse(new String(buf, "UTF-8"));
            }
            catch (Exception e) {
                throw new IOException("Deserialization error, could not parse the path. ", e);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buf = this.id.getBytes("UTF-8");
        out.writeInt(buf.length);
        out.write(buf);
        if (this.parentId == null) {
            out.writeInt(-1);
        } else {
            buf = this.parentId.getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
        if (this.name == null) {
            out.writeInt(-1);
        } else {
            buf = this.name.getAsString(true).getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
        if (this.path == null) {
            out.writeInt(-1);
        } else {
            buf = this.path.getAsString().getBytes("UTF-8");
            out.writeInt(buf.length);
            out.write(buf);
        }
    }
}

