/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class OracleMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    protected static final String FIND_NODES_BY_PARENTID_CQ_QUERY = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from JCR_MITEM I, JCR_MITEM P, JCR_MVALUE V where I.I_CLASS=1 and I.PARENT_ID=? and P.I_CLASS=2 and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID".replaceFirst("select", "select /*+ INDEX(I JCR_IDX_MITEM_PARENT_ID) INDEX(P JCR_IDX_MITEM_PARENT_ID) INDEX(V JCR_IDX_MVALUE_PROPERTY)*/");
    protected static final String FIND_PROPERTIES_BY_PARENTID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_MITEM I LEFT OUTER JOIN JCR_MVALUE V ON (V.PROPERTY_ID=I.ID) where I.I_CLASS=2 and I.PARENT_ID=? order by I.NAME".replaceFirst("select", "select /*+ INDEX(I JCR_IDX_MITEM_PARENT_ID) INDEX(V JCR_IDX_MVALUE_PROPERTY)*/");
    protected static final String FIND_ITEM_QPATH_BY_ID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.I_INDEX from JCR_MITEM I, (SELECT ID, PARENT_ID from JCR_MITEM where ID=?) J where I.ID = J.ID or I.ID = J.PARENT_ID".replaceFirst("SELECT", "SELECT /*+ INDEX(JCR_MITEM JCR_PK_MITEM) */");

    public OracleMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_NODES_BY_PARENTID_CQ = FIND_NODES_BY_PARENTID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_CQ = FIND_PROPERTIES_BY_PARENTID_CQ_QUERY;
        this.FIND_ITEM_QPATH_BY_ID_CQ = FIND_ITEM_QPATH_BY_ID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select /*+ INDEX(I JCR_FK_MITEM_PARENT) INDEX(V JCR_IDX_MVALUE_PROPERTY)*/ I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from JCR_MITEM I LEFT OUTER JOIN JCR_MVALUE V ON (V.PROPERTY_ID=I.ID)";
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_MVALUE V, JCR_MITEM P join ( select * from ( select A.*, ROWNUM r__ from ( select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_MITEM I  where I.I_CLASS=1 order by I.ID) A where ROWNUM <= ?) where r__ > ?) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and V.PROPERTY_ID=P.ID order by J.ID";
        this.FIND_NODES_BY_PARENTID_LAZILY_CQ = this.FIND_NODES_BY_PARENTID_LAZILY_CQ.replaceFirst("select", "select /*+ USE_NL(V) INDEX(I JCR_IDX_MITEM_N_ORDER_NUM) INDEX(P JCR_IDX_MITEM_PARENT_FK) INDEX(V JCR_IDX_MVALUE_PROPERTY) */");
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setInt(1, offset + limit);
        this.findNodesAndProperties.setInt(2, offset);
        return this.findNodesAndProperties.executeQuery();
    }
}

