/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.HtmlReducer;
import com.google.caja.util.CajaTestCase;

public class HtmlReducerTest
extends CajaTestCase {
    public final void testEmpty() throws Exception {
        this.assertSameReduced("");
    }

    public final void testHtml() throws Exception {
        this.assertReduced("", "<html></html>");
        this.assertReduced("<html lang=en>", "<html lang=en></html>");
        this.assertReduced("<html><!--comment-->", "<html><!--comment--></html>");
        this.assertReduced("</html><!--comment-->", "<html></html><!--comment-->");
    }

    public final void testHead() throws Exception {
        this.assertReduced("", "<head></head>");
        this.assertReduced("<title></title>", "<head><title></title></head>");
        this.assertReduced("<head><!-- comment -->", "<head><!-- comment --></head>");
        this.assertReduced("</head> ", "<head></head> ");
    }

    public final void testBody() throws Exception {
        this.assertReduced("", "<body></body>");
        this.assertReduced("<body><script>alert('Hello World')</script>", "<body><script>alert('Hello World')</script></body>");
        this.assertReduced("<body><style>p { color: pink }</style>", "<body><style>p { color: pink }</style></body>");
        this.assertReduced("<div>foo</div>", "<body><div>foo</div></body>");
        this.assertReduced("</body><!--comment-->", "<body></body><!--comment-->");
        this.assertSameReduced("<body><script>alert('Hello World')</script></body><!--comment-->");
    }

    public final void testListItem() throws Exception {
        this.assertReduced("<ol><li>One<li>Two<li>Three</li> <li>Four</ol>", "<ol><li>One</li><li>Two</li><li>Three</li> <li>Four</li></ol>");
        this.assertReduced("<ul><li>One<li>Two<li>Three</li> </ul>", "<ul><li>One</li><li>Two</li><li>Three</li> </ul>");
    }

    public final void testDefinitionList() throws Exception {
        this.assertReduced("<dl><dd>Foo<dt>bar<dd>baz<dd>boo</dl>", "<dl><dd>Foo</dd><dt>bar</dt><dd>baz</dd><dd>boo</dd></dl>");
    }

    public final void testParagraphs() throws Exception {
        this.assertReduced("<p>x <a>y</a><p>z<p>w<pre>c</pre><p>a</p><b>b</b>", "<p>x <a>y</a></p><p>z</p><p>w</p><pre>c</pre><p>a</p><b>b</b>");
    }

    public final void testOption() throws Exception {
        this.assertReduced("<option>", "<option></option>");
        this.assertReduced("<optgroup>", "<optgroup></optgroup>");
        this.assertReduced("<select><option></select>", "<select><option></option></select>");
        this.assertReduced("<select><optgroup></select>", "<select><optgroup></optgroup></select>");
        this.assertReduced("<select><optgroup><option><option></select>", "<select><optgroup><option></option><option></option></optgroup></select>");
        this.assertReduced("<select><optgroup><option><option></optgroup><option></select>", "<select><optgroup><option></option><option></option></optgroup><option></option></select>");
    }

    public final void testColumns() throws Exception {
        this.assertReduced("<colgroup><col /><col /><colgroup><col />", "<colgroup><col /><col /></colgroup><colgroup><col /></colgroup>");
    }

    public final void testTableSections() throws Exception {
        this.assertSameReduced("<table></table>");
        this.assertReduced("<table><tbody></table>", "<table><tbody></tbody></table>");
        this.assertReduced("<table><tr></table>", "<table><tbody><tr></tr></tbody></table>");
        this.assertReduced("<table><thead><tbody><tfoot></table>", "<table><thead></thead><tbody></tbody><tfoot></tfoot></table>");
    }

    public final void testRows() throws Exception {
        this.assertReduced("<table><tr><td>foo<th>bar<td>baz</table>", "<table><tbody><tr><td>foo</td><th>bar</th><td>baz</td></tbody></table>");
    }

    public final void testAttributes() throws Exception {
        this.assertReduced("<tbody xml:lang=\"en\"><tr>", "<tbody xml:lang=\"en\"><tr></tr></tbody>");
    }

    private void assertReduced(String expected, String input) throws Exception {
        StringBuilder actual = new StringBuilder();
        HtmlReducer.reduce(input, actual);
        HtmlReducerTest.assertEquals((String)expected, (String)actual.toString());
    }

    private void assertSameReduced(String html) throws Exception {
        this.assertReduced(html, html);
    }
}

